/*
 * Decompiled with CFR 0.152.
 */
package com.egi.services.mff.utility;

import com.egi.services.mff.api.AnatomyEGIA;
import com.egi.services.mff.api.Calibration;
import com.egi.services.mff.api.Categories;
import com.egi.services.mff.api.Category;
import com.egi.services.mff.api.Channel;
import com.egi.services.mff.api.ChannelStatus;
import com.egi.services.mff.api.Coordinates;
import com.egi.services.mff.api.CraniumNormals;
import com.egi.services.mff.api.Dipole;
import com.egi.services.mff.api.DipoleSet;
import com.egi.services.mff.api.Entry;
import com.egi.services.mff.api.Epoch;
import com.egi.services.mff.api.Epochs;
import com.egi.services.mff.api.Event;
import com.egi.services.mff.api.EventTrack;
import com.egi.services.mff.api.Field;
import com.egi.services.mff.api.Fields;
import com.egi.services.mff.api.FilePath;
import com.egi.services.mff.api.Filter;
import com.egi.services.mff.api.GeometryEGIG;
import com.egi.services.mff.api.History;
import com.egi.services.mff.api.Info;
import com.egi.services.mff.api.InfoN;
import com.egi.services.mff.api.InfoNFileTypeEEG;
import com.egi.services.mff.api.InfoNFileTypeJTF;
import com.egi.services.mff.api.InfoNFileTypePNSData;
import com.egi.services.mff.api.InfoNFileTypeSourceData;
import com.egi.services.mff.api.InfoNFileTypeSpectral;
import com.egi.services.mff.api.InfoNFileTypeTValues;
import com.egi.services.mff.api.JTFCategories;
import com.egi.services.mff.api.JTFCategory;
import com.egi.services.mff.api.Key;
import com.egi.services.mff.api.MovieSync;
import com.egi.services.mff.api.MovieSyncs;
import com.egi.services.mff.api.Neighbor;
import com.egi.services.mff.api.Notes;
import com.egi.services.mff.api.PNSSensor;
import com.egi.services.mff.api.PNSSet;
import com.egi.services.mff.api.Pair;
import com.egi.services.mff.api.PhoticStimFrequency;
import com.egi.services.mff.api.PhoticStimRunFile;
import com.egi.services.mff.api.PhoticStimSequence;
import com.egi.services.mff.api.Segment;
import com.egi.services.mff.api.Sensor;
import com.egi.services.mff.api.SensorLayout;
import com.egi.services.mff.api.Subject;
import com.egi.services.mff.api.SubjectInfo;
import com.egi.services.mff.api.Thread;
import com.egi.services.mff.api.Tool;
import com.egi.services.mff.api.TriangleSurface;
import com.egi.services.mff.api.Volume;
import com.egi.services.mff.interfaces.MarshallingProtocol;
import com.egi.services.mff.utility.MFFUtil;
import com.egi.services.mff.utility.ResourceMarshalException;
import com.egi.services.mff.utility.ResourceUnmarshalException;
import com.egi.services.mff.utility.ResourceValidationException;
import com.egi.services.mff.utility.XMLUtil;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLLocalFileResource
implements MarshallingProtocol {
    @Override
    public Object marshal(Object fromObject, String uri) throws ResourceMarshalException {
        Object rVal = fromObject;
        if (fromObject instanceof Categories) {
            Categories categories = (Categories)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("categories");
            root.setAttribute("xmlns", "http://www.egi.com/categories_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<Category> categoryList = categories.getCategories();
            if (categoryList != null) {
                for (Category category : categoryList) {
                    Element element = document.createElement("cat");
                    XMLUtil.appendChild(element, "name", category.getName(), false, document);
                    ArrayList<Segment> arrayList = category.getSegments();
                    if (arrayList != null) {
                        Element element2 = document.createElement("segments");
                        for (Segment segment : arrayList) {
                            ArrayList<Key> keys;
                            Element segmentNode = document.createElement("seg");
                            XMLUtil.setAttribute(segmentNode, "status", segment.getStatus(), false);
                            XMLUtil.appendChild(segmentNode, "name", segment.getName(), false, document);
                            ArrayList<String> arrayList2 = segment.getFaults();
                            if (arrayList2 != null) {
                                Element faultsNode = document.createElement("faults");
                                for (String string : arrayList2) {
                                    XMLUtil.appendChild(faultsNode, "fault", string, false, document);
                                }
                                segmentNode.appendChild(faultsNode);
                            }
                            if (segment.getClockStartTimePresent()) {
                                XMLUtil.appendChild(segmentNode, "clockStartTime", segment.getClockStartTime(), false, document);
                            }
                            XMLUtil.appendChild(segmentNode, "beginTime", Long.toString(segment.getBeginTime()), false, document);
                            XMLUtil.appendChild(segmentNode, "endTime", Long.toString(segment.getEndTime()), false, document);
                            XMLUtil.appendChild(segmentNode, "evtBegin", Long.toString(segment.getEventBegin()), false, document);
                            XMLUtil.appendChild(segmentNode, "evtEnd", Long.toString(segment.getEventEnd()), false, document);
                            ArrayList<ChannelStatus> channels = segment.getChannels();
                            if (channels != null) {
                                Element channelStatusNode = document.createElement("channelStatus");
                                for (ChannelStatus chanStatus : channels) {
                                    ArrayList<Integer> channelNumbers = chanStatus.getChannels();
                                    int numberOfChannels = channels.size();
                                    StringBuilder channelsStringBuffer = new StringBuilder();
                                    int channelCount = 0;
                                    for (Integer channel : channelNumbers) {
                                        if (channelCount == numberOfChannels) {
                                            channelsStringBuffer.append(channel.toString());
                                        } else {
                                            channelsStringBuffer.append(channel.toString()).append(" ");
                                        }
                                        ++channelCount;
                                    }
                                    channelsStringBuffer.trimToSize();
                                    Element chanNode = XMLUtil.appendChild(channelStatusNode, "channels", channelsStringBuffer.toString(), false, document);
                                    XMLUtil.setAttribute(chanNode, "exclusion", chanStatus.getExclusion(), false);
                                    XMLUtil.setAttribute(chanNode, "signalBin", Long.toString(chanStatus.getBinIndex()), false);
                                }
                                segmentNode.appendChild(channelStatusNode);
                            }
                            if ((keys = segment.getKeys()) != null) {
                                Element element3 = document.createElement("keys");
                                segmentNode.appendChild(element3);
                                for (Key key : keys) {
                                    if (key == null) continue;
                                    Element keyNode = document.createElement("key");
                                    element3.appendChild(keyNode);
                                    XMLUtil.appendChild(keyNode, "keyCode", key.getCode(), false, document);
                                    XMLUtil.appendChild(keyNode, "description", key.getDescription(), false, document);
                                    XMLUtil.setAttribute(XMLUtil.appendChild(keyNode, "data", key.getData(), false, document), "dataType", key.getDataType(), false);
                                }
                            }
                            element2.appendChild(segmentNode);
                        }
                        element.appendChild(element2);
                    }
                    root.appendChild(element);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Coordinates) {
            Coordinates coordinates = (Coordinates)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("coordinates");
            root.setAttribute("xmlns", "http://www.egi.com/coordinates_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            SensorLayout sensorLayout = coordinates.getSensorLayout();
            if (sensorLayout != null) {
                Element sensorLayoutNode = document.createElement("sensorLayout");
                XMLUtil.appendChild(sensorLayoutNode, "name", sensorLayout.getName(), false, document);
                ArrayList<Sensor> sensors = sensorLayout.getSensors();
                if (sensors != null) {
                    Element element = document.createElement("sensors");
                    for (Sensor sensor : sensors) {
                        Element sensorNode = document.createElement("sensor");
                        XMLUtil.appendChild(sensorNode, "name", sensor.getName(), true, document);
                        XMLUtil.appendChild(sensorNode, "number", Integer.toString(sensor.getNumber()), false, document);
                        XMLUtil.appendChild(sensorNode, "type", Integer.toString(sensor.getType()), false, document);
                        XMLUtil.appendChild(sensorNode, "x", Float.toString(sensor.getX()), false, document);
                        XMLUtil.appendChild(sensorNode, "y", Float.toString(sensor.getY()), false, document);
                        XMLUtil.appendChild(sensorNode, "z", Float.toString(sensor.getZ()), false, document);
                        if (sensor.getOriginalNumberPresent()) {
                            XMLUtil.appendChild(sensorNode, "originalNumber", Integer.toString(sensor.getOriginalNumber()), false, document);
                        }
                        if (sensor.getIdentifierPresent()) {
                            XMLUtil.appendChild(sensorNode, "identifier", Integer.toString(sensor.getIdentifier()), false, document);
                        }
                        XMLUtil.appendChild(element, sensorNode);
                    }
                    XMLUtil.appendChild(sensorLayoutNode, element);
                }
                XMLUtil.appendChild(root, sensorLayoutNode);
            }
            XMLUtil.appendChild(root, "acqTime", coordinates.getAcquisitionTime(), false, document);
            XMLUtil.appendChild(root, "acqMethod", coordinates.getAcquisitionMethod(), false, document);
            if (coordinates.getDefaultSubject()) {
                XMLUtil.appendChild(root, "defaultSubject", "true", false, document);
            } else {
                XMLUtil.appendChild(root, "defaultSubject", "false", false, document);
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof SensorLayout) {
            ArrayList<Integer> arrayList;
            ArrayList<Neighbor> arrayList3;
            ArrayList<ArrayList<Integer>> tilingSets;
            ArrayList<Thread> threads;
            SensorLayout sensorLayout = (SensorLayout)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("sensorLayout");
            root.setAttribute("xmlns", "http://www.egi.com/sensorLayout_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            XMLUtil.appendChild(root, "name", sensorLayout.getName(), false, document);
            ArrayList<Sensor> sensors = sensorLayout.getSensors();
            if (sensors != null) {
                Element sensorsNode = document.createElement("sensors");
                for (Sensor sensor : sensors) {
                    Element element = document.createElement("sensor");
                    XMLUtil.appendChild(element, "name", sensor.getName(), true, document);
                    XMLUtil.appendChild(element, "number", Integer.toString(sensor.getNumber()), false, document);
                    XMLUtil.appendChild(element, "type", Integer.toString(sensor.getType()), false, document);
                    XMLUtil.appendChild(element, "x", Float.toString(sensor.getX()), false, document);
                    XMLUtil.appendChild(element, "y", Float.toString(sensor.getY()), false, document);
                    XMLUtil.appendChild(element, "z", Float.toString(sensor.getZ()), false, document);
                    if (sensor.getOriginalNumberPresent()) {
                        XMLUtil.appendChild(element, "originalNumber", Integer.toString(sensor.getOriginalNumber()), false, document);
                    }
                    if (sensor.getIdentifierPresent()) {
                        XMLUtil.appendChild(element, "identifier", Integer.toString(sensor.getIdentifier()), false, document);
                    }
                    XMLUtil.appendChild(sensorsNode, element);
                }
                XMLUtil.appendChild(root, sensorsNode);
            }
            if ((threads = sensorLayout.getThreads()) != null) {
                Element threadsNode = document.createElement("threads");
                for (Thread thread : threads) {
                    String string = "" + thread.getFirst() + "," + thread.getSecond();
                    XMLUtil.appendChild(threadsNode, "thread", string, false, document);
                }
                XMLUtil.appendChild(root, threadsNode);
            }
            if ((tilingSets = sensorLayout.getTilingSets()) != null) {
                Element element = document.createElement("tilingSets");
                for (ArrayList<Integer> arrayList4 : tilingSets) {
                    int numberOfTiles = arrayList4.size();
                    StringBuilder tilesStringBuffer = new StringBuilder();
                    int tileCount = 1;
                    for (Integer tile : arrayList4) {
                        if (tileCount == numberOfTiles) {
                            tilesStringBuffer.append(tile.toString());
                        } else {
                            tilesStringBuffer.append(tile.toString()).append(" ");
                        }
                        ++tileCount;
                    }
                    tilesStringBuffer.trimToSize();
                    XMLUtil.appendChild(element, "tilingSet", tilesStringBuffer.toString(), false, document);
                }
                XMLUtil.appendChild(root, element);
            }
            if ((arrayList3 = sensorLayout.getNeighbors()) != null) {
                Element element = document.createElement("neighbors");
                for (Neighbor neighbor : arrayList3) {
                    ArrayList<Integer> neighborValues = neighbor.getNeighbors();
                    if (neighborValues == null) continue;
                    int numberOfNeighbors = neighborValues.size();
                    StringBuilder stringBuilder = new StringBuilder();
                    int neighborsCount = 1;
                    for (Integer n : neighborValues) {
                        if (neighborsCount == numberOfNeighbors) {
                            stringBuilder.append(n.toString());
                        } else {
                            stringBuilder.append(n.toString()).append(" ");
                        }
                        ++neighborsCount;
                    }
                    stringBuilder.trimToSize();
                    element.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("ch", stringBuilder.toString(), false, document), "n", Integer.toString(neighbor.getChannelNumber()), true));
                }
                XMLUtil.appendChild(root, element);
            }
            if ((arrayList = sensorLayout.getSpaces()) != null) {
                Element element = document.createElement("spaces");
                for (Integer space : arrayList) {
                    XMLUtil.appendChild(element, "space", space.toString(), false, document);
                }
                XMLUtil.appendChild(root, element);
            }
            XMLUtil.appendChild(root, "originalLayout", sensorLayout.getOriginalLayout(), false, document);
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException resourceValidationException) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Epochs) {
            Epochs epochs = (Epochs)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("epochs");
            root.setAttribute("xmlns", "http://www.egi.com/epochs_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<Epoch> epochList = epochs.getEpochs();
            if (epochList != null) {
                for (Epoch epoch : epochList) {
                    Element element = document.createElement("epoch");
                    XMLUtil.appendChild(element, "beginTime", Long.toString(epoch.getBeginTime()), false, document);
                    XMLUtil.appendChild(element, "endTime", Long.toString(epoch.getEndTime()), false, document);
                    XMLUtil.appendChild(element, "firstBlock", Long.toString(epoch.getFirstBlock()), false, document);
                    XMLUtil.appendChild(element, "lastBlock", Long.toString(epoch.getLastBlock()), false, document);
                    XMLUtil.appendChild(root, element);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof EventTrack) {
            EventTrack eventTrack = (EventTrack)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("eventTrack");
            root.setAttribute("xmlns", "http://www.egi.com/event_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            XMLUtil.appendChild(root, "name", eventTrack.getName(), false, document);
            XMLUtil.appendChild(root, "trackType", eventTrack.getTrackType(), false, document);
            ArrayList<Event> events = eventTrack.getEvents();
            if (events != null) {
                for (Event event : events) {
                    if (event == null) continue;
                    Element element = document.createElement("event");
                    root.appendChild(element);
                    XMLUtil.appendChild(element, "beginTime", event.getBeginTime(), false, document);
                    XMLUtil.appendChild(element, "relativeBeginTime", Long.toString(event.getRelativeBeginTime()), false, document);
                    XMLUtil.appendChild(element, "duration", Long.toString(event.getDuration()), false, document);
                    XMLUtil.appendChild(element, "code", event.getCode(), false, document);
                    XMLUtil.appendChild(element, "label", event.getLabel(), false, document);
                    XMLUtil.appendChild(element, "description", event.getDescription(), false, document);
                    XMLUtil.appendChild(element, "sourceDevice", event.getSourceDevice(), false, document);
                    XMLUtil.appendChild(element, "segmentationEvent", event.isSegmentationEvent() ? "true" : "false", false, document);
                    ArrayList<Key> arrayList = event.getKeys();
                    if (arrayList == null) continue;
                    Element element4 = document.createElement("keys");
                    XMLUtil.appendChild(element, element4);
                    for (Key key : arrayList) {
                        if (key == null) continue;
                        Element keyNode = document.createElement("key");
                        XMLUtil.appendChild(element4, keyNode);
                        XMLUtil.appendChild(keyNode, "keyCode", key.getCode(), false, document);
                        XMLUtil.appendChild(keyNode, "description", key.getDescription(), false, document);
                        XMLUtil.setAttribute(XMLUtil.appendChild(keyNode, "data", key.getData(), false, document), "dataType", key.getDataType(), false);
                    }
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof History) {
            History history = (History)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("historyEntries");
            root.setAttribute("xmlns", "http://www.egi.com/history_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<Entry> entries = history.getEntries();
            if (entries != null) {
                for (Entry entry : entries) {
                    if (entry == null) continue;
                    Element element = document.createElement("entry");
                    if (entry.getType().equals("tool")) {
                        ArrayList<String> results;
                        ArrayList<String> settings;
                        Element element5 = document.createElement("tool");
                        Tool tool = (Tool)entry.getEntry();
                        XMLUtil.appendChild(element5, "name", tool.getName(), false, document);
                        XMLUtil.appendChild(element5, "kind", tool.getKind(), false, document);
                        XMLUtil.appendChild(element5, "method", tool.getMethod(), false, document);
                        XMLUtil.appendChild(element5, "version", tool.getVersion(), false, document);
                        XMLUtil.appendChild(element5, "beginTime", tool.getBeginTime(), false, document);
                        XMLUtil.appendChild(element5, "endTime", tool.getEndTime(), false, document);
                        ArrayList<FilePath> sourceFiles = tool.getSourceFiles();
                        if (sourceFiles != null) {
                            Element sourceFilesNode = document.createElement("sourceFiles");
                            for (FilePath filePath : sourceFiles) {
                                Element filePathNode = XMLUtil.getElement("filePath", filePath.getFilePath(), false, document);
                                XMLUtil.setAttribute(filePathNode, "type", filePath.getType(), false);
                                XMLUtil.setAttribute(filePathNode, "creator", filePath.getCreator(), false);
                                XMLUtil.appendChild(sourceFilesNode, filePathNode);
                            }
                            XMLUtil.appendChild(element5, sourceFilesNode);
                        }
                        if ((settings = tool.getSettings()) != null) {
                            Element settingsNode = document.createElement("settings");
                            for (String setting : settings) {
                                XMLUtil.appendChild(settingsNode, "setting", setting, false, document);
                            }
                            XMLUtil.appendChild(element5, settingsNode);
                        }
                        if ((results = tool.getResults()) != null) {
                            Element element6 = document.createElement("results");
                            for (String result : results) {
                                XMLUtil.appendChild(element6, "result", result, false, document);
                            }
                            XMLUtil.appendChild(element5, element6);
                        }
                        XMLUtil.appendChild(element, element5);
                    }
                    XMLUtil.appendChild(root, element);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Info) {
            Info info = (Info)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("fileInfo");
            root.setAttribute("xmlns", "http://www.egi.com/info_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (info.getMFFVersionPresent()) {
                XMLUtil.appendChild(root, "mffVersion", Integer.toString(info.getMFFVersion()), false, document);
            }
            XMLUtil.appendChild(root, "recordTime", info.getRecordTime(), false, document);
            XMLUtil.appendChild(root, "ampSerialNumber", info.getAmpSerialNumber(), false, document);
            XMLUtil.appendChild(root, "ampFirmwareVersion", info.getAmpFirmwareVersion(), false, document);
            if (info.getMovieDeltaPresent()) {
                XMLUtil.appendChild(root, "movieDelta", Long.toString(info.getMovieDelta()), false, document);
            }
            if (info.isAmpTypePresent()) {
                XMLUtil.appendChild(root, "ampType", info.getAmpType(), false, document);
            }
            if (info.isAcquisitionVersionPresent()) {
                XMLUtil.appendChild(root, "acquisitionVersion", info.getAcquisitionVersionNumber(), false, document);
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof InfoN) {
            ArrayList<Calibration> arrayList;
            ArrayList<Filter> arrayList5;
            InfoN infoN = (InfoN)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("dataInfo");
            root.setAttribute("xmlns", "http://www.egi.com/info_n_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            Element generalInformationElement = document.createElement("generalInformation");
            Element fileDataTypeElement = document.createElement("fileDataType");
            switch (infoN.getInfoNFileType()) {
                case kUnknownInfoNFileType: {
                    break;
                }
                case kEEG: {
                    Element eegTypeElement = document.createElement("EEG");
                    eegTypeElement.appendChild(document.createElement("EEGFile"));
                    InfoNFileTypeEEG infoNFileTypeEEG = (InfoNFileTypeEEG)infoN.getInfoNFileTypeInformation();
                    XMLUtil.appendChild(eegTypeElement, "sensorLayoutName", infoNFileTypeEEG.getSensorLayoutName(), false, document);
                    XMLUtil.appendChild(eegTypeElement, "montageName", infoNFileTypeEEG.getMontageName(), false, document);
                    XMLUtil.appendChild(eegTypeElement, "referenceScheme", infoNFileTypeEEG.getReferenceScheme(), false, document);
                    XMLUtil.appendChild(fileDataTypeElement, eegTypeElement);
                    break;
                }
                case kSpectral: {
                    Element spectralTypeElement = document.createElement("spectral");
                    spectralTypeElement.appendChild(document.createElement("spectralFile"));
                    InfoNFileTypeSpectral infoNFileTypeSpectral = (InfoNFileTypeSpectral)infoN.getInfoNFileTypeInformation();
                    XMLUtil.appendChild(spectralTypeElement, "sensorLayoutName", infoNFileTypeSpectral.getSensorLayoutName(), false, document);
                    XMLUtil.appendChild(spectralTypeElement, "montageName", infoNFileTypeSpectral.getMontageName(), false, document);
                    XMLUtil.appendChild(spectralTypeElement, "deltaF", Double.toString(infoNFileTypeSpectral.getDeltaF()), false, document);
                    XMLUtil.appendChild(spectralTypeElement, "path", infoNFileTypeSpectral.getPath(), false, document);
                    XMLUtil.appendChild(spectralTypeElement, "beginTime", Long.toString(infoNFileTypeSpectral.getBeginTime()), false, document);
                    if (infoNFileTypeSpectral.getEndTimePresent()) {
                        XMLUtil.appendChild(spectralTypeElement, "endTime", Long.toString(infoNFileTypeSpectral.getEndTime()), false, document);
                    }
                    XMLUtil.appendChild(spectralTypeElement, "minX", Float.toString(infoNFileTypeSpectral.getMinX()), false, document);
                    XMLUtil.appendChild(spectralTypeElement, "maxX", Float.toString(infoNFileTypeSpectral.getMaxX()), false, document);
                    XMLUtil.appendChild(spectralTypeElement, "minY", Float.toString(infoNFileTypeSpectral.getMinY()), false, document);
                    XMLUtil.appendChild(spectralTypeElement, "maxY", Float.toString(infoNFileTypeSpectral.getMaxY()), false, document);
                    XMLUtil.appendChild(fileDataTypeElement, spectralTypeElement);
                    break;
                }
                case kSourceData: {
                    Element sourceDataTypeElement = document.createElement("sourceData");
                    sourceDataTypeElement.appendChild(document.createElement("sourceDataFile"));
                    InfoNFileTypeSourceData infoNFileTypeSourceData = (InfoNFileTypeSourceData)infoN.getInfoNFileTypeInformation();
                    XMLUtil.appendChild(sourceDataTypeElement, "dipoleSetName", infoNFileTypeSourceData.getDipoleSetName(), false, document);
                    XMLUtil.appendChild(sourceDataTypeElement, "numberOfOrientation", Long.toString(infoNFileTypeSourceData.getNumberOfOrientation()), false, document);
                    XMLUtil.appendChild(fileDataTypeElement, sourceDataTypeElement);
                    break;
                }
                case kPNSData: {
                    Element pnsTypeElement = document.createElement("PNSData");
                    pnsTypeElement.appendChild(document.createElement("PNSDataFile"));
                    InfoNFileTypePNSData infoNFileTypePNSData = (InfoNFileTypePNSData)infoN.getInfoNFileTypeInformation();
                    XMLUtil.appendChild(pnsTypeElement, "pnsSetName", infoNFileTypePNSData.getPNSSetName(), false, document);
                    XMLUtil.appendChild(fileDataTypeElement, pnsTypeElement);
                    break;
                }
                case kJTF: {
                    Element jtfTypeElement = document.createElement("JTF");
                    jtfTypeElement.appendChild(document.createElement("JTFFile"));
                    InfoNFileTypeJTF infoNFileTypeJTF = (InfoNFileTypeJTF)infoN.getInfoNFileTypeInformation();
                    XMLUtil.appendChild(jtfTypeElement, "sensorLayoutName", infoNFileTypeJTF.getSensorLayoutName(), false, document);
                    XMLUtil.appendChild(jtfTypeElement, "montageName", infoNFileTypeJTF.getMontageName(), false, document);
                    XMLUtil.appendChild(jtfTypeElement, "path", infoNFileTypeJTF.getPath(), false, document);
                    XMLUtil.appendChild(jtfTypeElement, "samplingRate", Long.toString(infoNFileTypeJTF.getSamplingRate()), false, document);
                    XMLUtil.appendChild(fileDataTypeElement, jtfTypeElement);
                    break;
                }
                case kTValues: {
                    Element tValuesTypeElement = document.createElement("tValues");
                    tValuesTypeElement.appendChild(document.createElement("tValuesFile"));
                    InfoNFileTypeTValues infoNFileTypeTValues = (InfoNFileTypeTValues)infoN.getInfoNFileTypeInformation();
                    XMLUtil.appendChild(tValuesTypeElement, "sensorLayoutName", infoNFileTypeTValues.getSensorLayoutName(), false, document);
                    XMLUtil.appendChild(tValuesTypeElement, "sensorLayoutName", infoNFileTypeTValues.getMontageName(), false, document);
                    XMLUtil.appendChild(fileDataTypeElement, tValuesTypeElement);
                }
            }
            XMLUtil.appendChild(generalInformationElement, fileDataTypeElement);
            XMLUtil.appendChild(root, generalInformationElement);
            ChannelStatus chanStatus = infoN.getChannelStatus();
            if (chanStatus != null) {
                ArrayList<Integer> arrayList6 = chanStatus.getChannels();
                int n = arrayList6.size();
                StringBuilder stringBuilder = new StringBuilder();
                int channelCount = 0;
                for (Integer channel : arrayList6) {
                    if (channelCount == n) {
                        stringBuilder.append(channel.toString());
                    } else {
                        stringBuilder.append(channel.toString()).append(" ");
                    }
                    ++channelCount;
                }
                stringBuilder.trimToSize();
                XMLUtil.setAttribute(XMLUtil.appendChild(root, "channels", stringBuilder.toString(), false, document), "exclusion", chanStatus.getExclusion(), false);
            }
            if ((arrayList5 = infoN.getFilters()) != null) {
                Element element = document.createElement("filters");
                for (Filter filter : arrayList5) {
                    Element filterNode = document.createElement("filter");
                    XMLUtil.appendChild(filterNode, "beginTime", Long.toString(filter.getBeginTime()), false, document);
                    if (filter.getEndTimePresent()) {
                        XMLUtil.appendChild(filterNode, "endTime", Long.toString(filter.getEndTime()), false, document);
                    }
                    XMLUtil.appendChild(filterNode, "method", filter.getMethod(), false, document);
                    XMLUtil.appendChild(filterNode, "type", filter.getType(), false, document);
                    if (filter.getSamplingFrequencyPresent()) {
                        filterNode.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("samplingFrequency", Double.toString(filter.getSamplingFrequency()), false, document), "units", filter.getSamplingFrequencyUnits(), false));
                    }
                    if (filter.getCutoffFrequencyPresent()) {
                        filterNode.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("cutoffFrequency", Double.toString(filter.getCutoffFrequency()), false, document), "units", filter.getCutoffFrequencyUnits(), false));
                    }
                    if (filter.getPassbandAttenuationPresent()) {
                        filterNode.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("passbandAttenuation", Double.toString(filter.getPassbandAttenuation()), false, document), "units", filter.getPassbandAttenuationUnits(), false));
                    }
                    XMLUtil.appendChild(element, filterNode);
                }
                XMLUtil.appendChild(root, element);
            }
            if ((arrayList = infoN.getCalibrations()) != null) {
                Element element = document.createElement("calibrations");
                for (Calibration calibration : arrayList) {
                    Element calNode = document.createElement("calibration");
                    XMLUtil.appendChild(calNode, "beginTime", Long.toString(calibration.getBeginTime()), false, document);
                    if (calibration.getEndTime() != 0L) {
                        XMLUtil.appendChild(calNode, "endTime", Long.toString(calibration.getEndTime()), false, document);
                    }
                    XMLUtil.appendChild(calNode, "type", calibration.getType(), false, document);
                    Element element7 = document.createElement("channels");
                    for (Channel channel : calibration.getChannels()) {
                        calNode.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("ch", channel.getChannelData(), false, document), "n", Long.toString(channel.getChannelNumber()), false));
                    }
                    XMLUtil.appendChild(element, element7);
                    XMLUtil.appendChild(element, calNode);
                }
                XMLUtil.appendChild(root, element);
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException resourceValidationException) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Subject) {
            ArrayList<String> mris;
            Subject subject = (Subject)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("patient");
            root.setAttribute("xmlns", "http://www.egi.com/subject_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<Field> fields = subject.getFields();
            if (fields != null) {
                Element fieldsNode = document.createElement("fields");
                for (Field field : fields) {
                    if (field == null) continue;
                    Element element = document.createElement("field");
                    XMLUtil.appendChild(element, "name", field.getName(), false, document);
                    element.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("data", field.getData(), false, document), "dataType", field.getDataType(), false));
                    XMLUtil.appendChild(element, "choices", field.getChoices(), false, document);
                    XMLUtil.appendChild(fieldsNode, element);
                }
                XMLUtil.appendChild(root, fieldsNode);
            }
            if ((mris = subject.getMRIS()) != null) {
                Element mrisNode = document.createElement("MRIs");
                for (String string : mris) {
                    XMLUtil.appendChild(mrisNode, "fileName", string, false, document);
                }
                XMLUtil.appendChild(root, mrisNode);
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof PNSSet) {
            PNSSet pnsSet = (PNSSet)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("PNSSet");
            root.setAttribute("xmlns", "http://www.egi.com/pnsSet_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            XMLUtil.appendChild(root, "name", pnsSet.getName(), false, document);
            XMLUtil.appendChild(root, "ampSeries", pnsSet.getAmpSeries(), false, document);
            ArrayList<PNSSensor> pnsSensors = pnsSet.getPNSSensors();
            if (pnsSensors != null) {
                Element sensorsNode = document.createElement("sensors");
                for (PNSSensor pNSSensor : pnsSensors) {
                    Element element = document.createElement("sensor");
                    XMLUtil.appendChild(element, "name", pNSSensor.getName(), true, document);
                    XMLUtil.appendChild(element, "number", Integer.toString(pNSSensor.getNumber()), false, document);
                    XMLUtil.appendChild(element, "unit", pNSSensor.getUnit(), false, document);
                    XMLUtil.appendChild(element, "psgType", Integer.toString(pNSSensor.getPSGType()), false, document);
                    XMLUtil.appendChild(element, "mapping", Integer.toString(pNSSensor.getMapping()), false, document);
                    XMLUtil.appendChild(element, "samplingRate", Long.toString(pNSSensor.getSamplingRate()), false, document);
                    if (pNSSensor.getSensorType() != null) {
                        XMLUtil.appendChild(element, "sensorType", pNSSensor.getSensorType(), false, document);
                    }
                    if (pNSSensor.getHighpassPresent()) {
                        XMLUtil.appendChild(element, "highpass", Double.toString(pNSSensor.getHighpass()), false, document);
                    }
                    if (pNSSensor.getLowpassPresent()) {
                        XMLUtil.appendChild(element, "lowpass", Double.toString(pNSSensor.getLowpass()), false, document);
                    }
                    if (pNSSensor.getNotchPresent()) {
                        XMLUtil.appendChild(element, "notch", Double.toString(pNSSensor.getNotch()), false, document);
                    }
                    if (pNSSensor.getGroupNumberPresent()) {
                        XMLUtil.appendChild(element, "groupNumber", Integer.toString(pNSSensor.getGroupNumber()), false, document);
                    }
                    if (pNSSensor.getConversionPresent()) {
                        XMLUtil.appendChild(element, "conversion", Integer.toString(pNSSensor.getConversion()), false, document);
                    }
                    if (pNSSensor.isGainPresent()) {
                        XMLUtil.appendChild(element, "gain", Float.toString(pNSSensor.getGain()), false, document);
                    }
                    if (pNSSensor.isDefaultAmplitudePresent()) {
                        XMLUtil.appendChild(element, "defaultDisplayAmplitude", Float.toString(pNSSensor.getDefaultAmplitude()), false, document);
                    }
                    if (pNSSensor.isDefaultDisplayHighpassPresent()) {
                        XMLUtil.appendChild(element, "highpassDisplay", Double.toString(pNSSensor.getDefaultDisplayHighpass()), false, document);
                    }
                    if (pNSSensor.isDefaultDisplayLowpassPresent()) {
                        XMLUtil.appendChild(element, "lowpassDisplay", Double.toString(pNSSensor.getDefaultDisplayLowpass()), false, document);
                    }
                    if (pNSSensor.isDefaultDisplayNotchPresent()) {
                        XMLUtil.appendChild(element, "notchDisplay", Double.toString(pNSSensor.getDefaultDisplayNotch()), false, document);
                    }
                    if (pNSSensor.isColorPresent()) {
                        XMLUtil.appendChild(element, "color", pNSSensor.getColorString(), false, document);
                    }
                    if (pNSSensor.isPolarityPresent()) {
                        XMLUtil.appendChild(element, "positiveUp", pNSSensor.isPositiveUp() ? "true" : "false", false, document);
                    }
                    XMLUtil.appendChild(sensorsNode, element);
                }
                XMLUtil.appendChild(root, sensorsNode);
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof DipoleSet) {
            String locString;
            Element sensorsNode;
            DipoleSet dipoleSet = (DipoleSet)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("dipoleSet");
            root.setAttribute("xmlns", "http://www.egi.com/dipoleSet_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            XMLUtil.appendChild(root, "name", dipoleSet.getName(), false, document);
            XMLUtil.appendChild(root, "type", dipoleSet.getType(), false, document);
            XMLUtil.appendChild(root, "subjectID", dipoleSet.getSubjectID(), false, document);
            ArrayList<Dipole> theDipoles = dipoleSet.getDipoles();
            if (theDipoles != null) {
                sensorsNode = document.createElement("dipoles");
                for (Dipole dipole : theDipoles) {
                    Element element = document.createElement("dipole");
                    XMLUtil.appendChild(element, "name", dipole.getName(), true, document);
                    float[] fArray = dipole.getComputationLocation();
                    locString = String.format("%.2f,%.2f,%.2f", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]));
                    XMLUtil.appendChild(element, "computationCoordinate", locString, false, document);
                    float[] fArray2 = dipole.getVisualizationLocation();
                    locString = String.format("%.2f,%.2f,%.2f", Float.valueOf(fArray2[0]), Float.valueOf(fArray2[1]), Float.valueOf(fArray2[2]));
                    XMLUtil.appendChild(element, "visualizationCoordinate", locString, false, document);
                    XMLUtil.appendChild(sensorsNode, element);
                }
                XMLUtil.appendChild(root, sensorsNode);
            }
            if ((theDipoles = dipoleSet.getFidutials()) != null) {
                sensorsNode = document.createElement("fidutial");
                for (Dipole dipole : theDipoles) {
                    Element element = document.createElement("dipole");
                    XMLUtil.appendChild(element, "name", dipole.getName(), true, document);
                    float[] fArray = dipole.getComputationLocation();
                    locString = String.format("%.2f,%.2f,%.2f", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]));
                    XMLUtil.appendChild(element, "computationCoordinate", locString, false, document);
                    float[] fArray3 = dipole.getVisualizationLocation();
                    locString = String.format("%.2f,%.2f,%.2f", Float.valueOf(fArray3[0]), Float.valueOf(fArray3[1]), Float.valueOf(fArray3[2]));
                    XMLUtil.appendChild(element, "visualizationCoordinate", locString, false, document);
                    XMLUtil.appendChild(sensorsNode, element);
                }
                XMLUtil.appendChild(root, sensorsNode);
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Fields) {
            Fields theFields = (Fields)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("fields");
            root.setAttribute("xmlns", "http://www.egi.com/fields_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<Field> fields = theFields.getFields();
            if (fields != null) {
                for (Field field : fields) {
                    if (field == null) continue;
                    Element element = document.createElement("field");
                    XMLUtil.appendChild(element, "name", field.getName(), false, document);
                    Element element8 = document.createElement("data");
                    element.appendChild(XMLUtil.setAttribute(XMLUtil.getElement("data", field.getData(), false, document), "dataType", field.getDataType(), false));
                    XMLUtil.appendChild(element, "choices", field.getChoices(), false, document);
                    XMLUtil.appendChild(root, element);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof Notes) {
            Notes theNotes = (Notes)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("notes");
            root.setAttribute("xmlns", "http://www.egi.com/notes_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            String note = theNotes.getNotes();
            if (note != null) {
                root.setTextContent(note);
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof JTFCategories) {
            JTFCategories categories = (JTFCategories)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("jtfCategories");
            root.setAttribute("xmlns", "http://www.egi.com/jtfCategories_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<JTFCategory> categoryList = categories.getCategories();
            if (categoryList != null) {
                for (JTFCategory category : categoryList) {
                    Element element = document.createElement("cat");
                    XMLUtil.appendChild(element, "name", category.getName(), false, document);
                    XMLUtil.appendChild(element, "numberOfSegments", Long.toString(category.getNumberOfSegment()), false, document);
                    XMLUtil.appendChild(element, "segmentEventTime", Long.toString(category.getSegmentEventTime()), false, document);
                    XMLUtil.appendChild(element, "duration", Long.toString(category.getDuration()), false, document);
                    ArrayList<Double> arrayList = category.getFrequencies();
                    if (arrayList != null) {
                        Element element9 = document.createElement("frequencies");
                        for (Double freq : arrayList) {
                            XMLUtil.appendChild(element9, "freq", freq.toString(), false, document);
                        }
                        element.appendChild(element9);
                    }
                    XMLUtil.appendChild(element, "minPower", Double.toString(category.getMinPower()), false, document);
                    XMLUtil.appendChild(element, "maxPower", Double.toString(category.getMaxPower()), false, document);
                    if (category.isPhasePresent()) {
                        XMLUtil.appendChild(element, "hasPhase", "true", false, document);
                        XMLUtil.appendChild(element, "minPhase", Double.toString(category.getMinPhase()), false, document);
                        XMLUtil.appendChild(element, "maxPhase", Double.toString(category.getMaxPhase()), false, document);
                    }
                    root.appendChild(element);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof MovieSyncs) {
            MovieSyncs movieSyncs = (MovieSyncs)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("movieSyncs");
            root.setAttribute("xmlns", "http://www.egi.com/movieSyncs_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<MovieSync> syncList = movieSyncs.getMovieSyncs();
            if (syncList != null) {
                for (MovieSync sync : syncList) {
                    Element element = document.createElement("movieSync");
                    XMLUtil.appendChild(element, "fileName", sync.getFileName(), false, document);
                    XMLUtil.appendChild(element, "sampleBeginTime", Long.toString(sync.getSampleBeginTime()), false, document);
                    XMLUtil.appendChild(element, "sampleEndTime", Long.toString(sync.getSampleEndTime()), false, document);
                    XMLUtil.appendChild(element, "videoBeginTime", Double.toString(sync.getVideoBeginTime()), false, document);
                    XMLUtil.appendChild(element, "videoEndTime", Double.toString(sync.getVideoEndTime()), false, document);
                    XMLUtil.appendChild(element, "category", Long.toString(sync.getCategory()), false, document);
                    XMLUtil.appendChild(element, "segment", Long.toString(sync.getSegment()), false, document);
                    root.appendChild(element);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        if (fromObject instanceof PhoticStimRunFile) {
            PhoticStimRunFile runFile = (PhoticStimRunFile)fromObject;
            Document document = XMLUtil.newXMLDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("photicStimRun");
            root.setAttribute("xmlns", "http://www.egi.com/photicStimRun_mff");
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ArrayList<PhoticStimSequence> protocols = runFile.getSequences();
            if (protocols != null) {
                for (PhoticStimSequence protocol : protocols) {
                    Element element = document.createElement("frequencyTrainRun");
                    XMLUtil.appendChild(element, "name", protocol.getName(), false, document);
                    XMLUtil.appendChild(element, "beginTime", Long.toString(protocol.getBeginTime()), false, document);
                    if (protocol.useStartEvent()) {
                        XMLUtil.appendChild(element, "useStartEvent", "true", false, document);
                        XMLUtil.appendChild(element, "startEvent", protocol.getStartEventLabel(), false, document);
                    } else {
                        XMLUtil.appendChild(element, "useStartEvent", "false", false, document);
                    }
                    if (protocol.useEndEvent()) {
                        XMLUtil.appendChild(element, "useEndEvent", "true", false, document);
                        XMLUtil.appendChild(element, "endEvent", protocol.getEndEventLabel(), false, document);
                    } else {
                        XMLUtil.appendChild(element, "useEndEvent", "false", false, document);
                    }
                    if (protocol.useFlashEvent()) {
                        XMLUtil.appendChild(element, "useFlashEvent", "true", false, document);
                        XMLUtil.appendChild(element, "flashEvent", protocol.getFlashEventLabel(), false, document);
                    } else {
                        XMLUtil.appendChild(element, "useFlashEvent", "false", false, document);
                    }
                    Element element10 = document.createElement("frequencyTrain");
                    ArrayList<PhoticStimFrequency> arrayList = protocol.getSequences();
                    for (PhoticStimFrequency flashFreq : arrayList) {
                        Element pulseNode = document.createElement("pulseSequence");
                        XMLUtil.appendChild(pulseNode, "frequency", Float.toString(flashFreq.getFrequency()), false, document);
                        XMLUtil.appendChild(pulseNode, "duration", Integer.toString(flashFreq.getDuration()), false, document);
                        XMLUtil.appendChild(pulseNode, "rest", Integer.toString(flashFreq.getRest()), false, document);
                        XMLUtil.appendChild(pulseNode, "repeat", Integer.toString(flashFreq.getRepeatCount()), false, document);
                        element10.appendChild(pulseNode);
                    }
                    element.appendChild(element10);
                    root.appendChild(element);
                }
            }
            document.appendChild(root);
            try {
                XMLUtil.transformDOMtoURI(uri, null, document, null, false);
            }
            catch (ResourceValidationException ex) {
                throw new ResourceMarshalException("data source did not validate");
            }
        }
        return rVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object unmarshal(Object toObject, String uri) throws ResourceUnmarshalException {
        Element root;
        Object rVal = toObject;
        if (toObject instanceof Categories) {
            Categories categories = (Categories)toObject;
            ArrayList<Category> categoryList = new ArrayList<Category>();
            Document document = null;
            try {
                document = XMLUtil.getDocumentFromURI(uri);
            }
            catch (ResourceUnmarshalException ex) {
                MFFUtil.updateXMLVersion(uri);
                document = XMLUtil.getDocumentFromURI(uri);
            }
            if (document == null) return rVal;
            Element root2 = document.getDocumentElement();
            if (root2 != null) {
                root2.normalize();
            }
            if (!root2.getNodeName().equals("categories")) return rVal;
            for (Node categoriesChild = root2.getFirstChild(); categoriesChild != null; categoriesChild = categoriesChild.getNextSibling()) {
                if (!categoriesChild.getNodeName().equals("cat")) continue;
                Category category = new Category();
                for (Node categoryChild = categoriesChild.getFirstChild(); categoryChild != null; categoryChild = categoryChild.getNextSibling()) {
                    if (categoryChild.getNodeName().equals("name")) {
                        category.setName(categoryChild.getTextContent());
                        continue;
                    }
                    if (!categoryChild.getNodeName().equals("segments")) continue;
                    ArrayList<Segment> segments = new ArrayList<Segment>();
                    for (Node segmentsChild = categoryChild.getFirstChild(); segmentsChild != null; segmentsChild = segmentsChild.getNextSibling()) {
                        if (!segmentsChild.getNodeName().equals("seg")) continue;
                        Segment segment = new Segment();
                        segment.setStatus(XMLUtil.getAttribute(segmentsChild, "status"));
                        for (Node segmentChild = segmentsChild.getFirstChild(); segmentChild != null; segmentChild = segmentChild.getNextSibling()) {
                            if (segmentChild.getNodeName().equals("name")) {
                                segment.setName(segmentChild.getTextContent());
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("faults")) {
                                ArrayList<String> faults = new ArrayList<String>();
                                for (Node faultsChild = segmentChild.getFirstChild(); faultsChild != null; faultsChild = faultsChild.getNextSibling()) {
                                    faults.add(faultsChild.getTextContent());
                                }
                                segment.setFaults(faults);
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("clockStartTime")) {
                                segment.setClockStartTime(segmentChild.getTextContent());
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("beginTime")) {
                                segment.setBeginTime(Long.parseLong(segmentChild.getTextContent()));
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("endTime")) {
                                segment.setEndTime(Long.parseLong(segmentChild.getTextContent()));
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("evtBegin")) {
                                segment.setEventBegin(Long.parseLong(segmentChild.getTextContent()));
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("evtEnd")) {
                                segment.setEventEnd(Long.parseLong(segmentChild.getTextContent()));
                                continue;
                            }
                            if (segmentChild.getNodeName().equals("channelStatus")) {
                                ArrayList<ChannelStatus> channelStatus = new ArrayList<ChannelStatus>();
                                for (Node chanStatusChild = segmentChild.getFirstChild(); chanStatusChild != null; chanStatusChild = chanStatusChild.getNextSibling()) {
                                    if (!chanStatusChild.getNodeName().equals("channels")) continue;
                                    ChannelStatus chanStatus = new ChannelStatus();
                                    chanStatus.setExclusion(XMLUtil.getAttribute(chanStatusChild, "exclusion"));
                                    chanStatus.setBinIndex(Integer.parseInt(XMLUtil.getAttribute(chanStatusChild, "signalBin")));
                                    ArrayList<Integer> chanList = new ArrayList<Integer>();
                                    String channelList = chanStatusChild.getTextContent();
                                    if (!channelList.isEmpty()) {
                                        String[] channelNum;
                                        channelList = channelList.replaceAll("\\n", "");
                                        for (String cNum : channelNum = channelList.split(" ")) {
                                            chanList.add(new Integer(cNum));
                                        }
                                    }
                                    chanStatus.setChannels(chanList);
                                    channelStatus.add(chanStatus);
                                }
                                segment.setChannels(channelStatus);
                                continue;
                            }
                            if (!segmentChild.getNodeName().equals("keys")) continue;
                            ArrayList<Key> keys = new ArrayList<Key>();
                            for (Node keysChild = segmentChild.getFirstChild(); keysChild != null; keysChild = keysChild.getNextSibling()) {
                                if (!keysChild.getNodeName().equals("key")) continue;
                                Key key = new Key();
                                for (Node keyChild = keysChild.getFirstChild(); keyChild != null; keyChild = keyChild.getNextSibling()) {
                                    if (keyChild.getNodeName().equals("keyCode")) {
                                        key.setCode(keyChild.getTextContent());
                                        continue;
                                    }
                                    if (keyChild.getNodeName().equals("description")) {
                                        key.setDescription(keyChild.getTextContent());
                                        continue;
                                    }
                                    if (!keyChild.getNodeName().equals("data")) continue;
                                    key.setDataType(XMLUtil.getAttribute(keyChild, "dataType"));
                                    key.setData(keyChild.getTextContent());
                                }
                                keys.add(key);
                            }
                            segment.setKeys(keys);
                        }
                        segments.add(segment);
                    }
                    category.setSegments(segments);
                }
                categoryList.add(category);
            }
            categories.setCategories(categoryList);
            return rVal;
        }
        if (toObject instanceof Coordinates) {
            Element root3;
            Coordinates coordinates = (Coordinates)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null || (root3 = document.getDocumentElement()) == null) return rVal;
            root3.normalize();
            if (!root3.getNodeName().equals("coordinates")) return rVal;
            for (Node coordinatesChild = root3.getFirstChild(); coordinatesChild != null; coordinatesChild = coordinatesChild.getNextSibling()) {
                if (coordinatesChild.getNodeName().equals("sensorLayout")) {
                    SensorLayout sensorLayout = new SensorLayout();
                    for (Node sensorLayoutChild = coordinatesChild.getFirstChild(); sensorLayoutChild != null; sensorLayoutChild = sensorLayoutChild.getNextSibling()) {
                        if (sensorLayoutChild.getNodeName().equals("name")) {
                            sensorLayout.setName(sensorLayoutChild.getTextContent());
                            continue;
                        }
                        if (!sensorLayoutChild.getNodeName().equals("sensors")) continue;
                        ArrayList<Sensor> sensors = new ArrayList<Sensor>();
                        for (Node sensorsChild = sensorLayoutChild.getFirstChild(); sensorsChild != null; sensorsChild = sensorsChild.getNextSibling()) {
                            if (!sensorsChild.getNodeName().equals("sensor")) continue;
                            Sensor sensor = new Sensor();
                            for (Node sensorChild = sensorsChild.getFirstChild(); sensorChild != null; sensorChild = sensorChild.getNextSibling()) {
                                if (sensorChild.getNodeName().equals("name")) {
                                    sensor.setName(sensorChild.getTextContent());
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("number")) {
                                    sensor.setNumber(Integer.parseInt(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("type")) {
                                    sensor.setType(Integer.parseInt(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("x")) {
                                    sensor.setX(Float.parseFloat(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("y")) {
                                    sensor.setY(Float.parseFloat(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("z")) {
                                    sensor.setZ(Float.parseFloat(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (sensorChild.getNodeName().equals("originalNumber")) {
                                    sensor.setOriginalNumber(Integer.parseInt(sensorChild.getTextContent()));
                                    continue;
                                }
                                if (!sensorChild.getNodeName().equals("identifier")) continue;
                                sensor.setIdentifier(Integer.parseInt(sensorChild.getTextContent()));
                            }
                            sensors.add(sensor);
                        }
                        sensorLayout.setSensors(sensors);
                    }
                    coordinates.setSensorLayout(sensorLayout);
                    continue;
                }
                if (coordinatesChild.getNodeName().equals("acqTime")) {
                    coordinates.setAcquisitionTime(coordinatesChild.getTextContent());
                    continue;
                }
                if (coordinatesChild.getNodeName().equals("acqMethod")) {
                    coordinates.setAcquisitionMethod(coordinatesChild.getTextContent());
                    continue;
                }
                if (!coordinatesChild.getNodeName().equals("defaultSubject")) continue;
                if (coordinatesChild.getTextContent().equals("true")) {
                    coordinates.setDefaultSubject(true);
                    continue;
                }
                coordinates.setDefaultSubject(false);
            }
            return rVal;
        }
        if (toObject instanceof SensorLayout) {
            Element root4;
            SensorLayout sensorLayout = (SensorLayout)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null || (root4 = document.getDocumentElement()) == null) return rVal;
            root4.normalize();
            if (!root4.getNodeName().equals("sensorLayout")) return rVal;
            for (Node sensorLayoutChild = root4.getFirstChild(); sensorLayoutChild != null; sensorLayoutChild = sensorLayoutChild.getNextSibling()) {
                String[] parts;
                if (sensorLayoutChild.getNodeName().equals("name")) {
                    sensorLayout.setName(sensorLayoutChild.getTextContent());
                    continue;
                }
                if (sensorLayoutChild.getNodeName().equals("sensors")) {
                    ArrayList<Sensor> sensors = new ArrayList<Sensor>();
                    for (Node sensorsChild = sensorLayoutChild.getFirstChild(); sensorsChild != null; sensorsChild = sensorsChild.getNextSibling()) {
                        if (!sensorsChild.getNodeName().equals("sensor")) continue;
                        Sensor sensor = new Sensor();
                        for (Node sensorChild = sensorsChild.getFirstChild(); sensorChild != null; sensorChild = sensorChild.getNextSibling()) {
                            if (sensorChild.getNodeName().equals("name")) {
                                sensor.setName(sensorChild.getTextContent());
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("number")) {
                                sensor.setNumber(Integer.parseInt(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("type")) {
                                sensor.setType(Integer.parseInt(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("x")) {
                                sensor.setX(Float.parseFloat(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("y")) {
                                sensor.setY(Float.parseFloat(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("z")) {
                                sensor.setZ(Float.parseFloat(sensorChild.getTextContent()));
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("originalNumber")) {
                                sensor.setOriginalNumber(Integer.parseInt(sensorChild.getTextContent()));
                                continue;
                            }
                            if (!sensorChild.getNodeName().equals("identifier")) continue;
                            sensor.setIdentifier(Integer.parseInt(sensorChild.getTextContent()));
                        }
                        sensors.add(sensor);
                    }
                    sensorLayout.setSensors(sensors);
                    continue;
                }
                if (sensorLayoutChild.getNodeName().equals("threads")) {
                    ArrayList<Thread> threads = new ArrayList<Thread>();
                    for (Node threadsChild = sensorLayoutChild.getFirstChild(); threadsChild != null; threadsChild = threadsChild.getNextSibling()) {
                        String threadString;
                        if (!threadsChild.getNodeName().equals("thread") || (threadString = threadsChild.getTextContent()) == null) continue;
                        Thread thread = new Thread();
                        parts = threadString.split(",");
                        if (parts.length == 2) {
                            thread.setFirst(Integer.parseInt(parts[0].trim()));
                            thread.setSecond(Integer.parseInt(parts[1].trim()));
                        }
                        threads.add(thread);
                    }
                    sensorLayout.setThreads(threads);
                    continue;
                }
                if (sensorLayoutChild.getNodeName().equals("tilingSets")) {
                    ArrayList<ArrayList<Integer>> tilingSets = new ArrayList<ArrayList<Integer>>();
                    for (Node tilingSetsChild = sensorLayoutChild.getFirstChild(); tilingSetsChild != null; tilingSetsChild = tilingSetsChild.getNextSibling()) {
                        String tilingSetString;
                        if (!tilingSetsChild.getNodeName().equals("tilingSet") || (tilingSetString = tilingSetsChild.getTextContent()) == null) continue;
                        ArrayList<Integer> tilingSet = new ArrayList<Integer>();
                        for (String tilingSetMember : parts = tilingSetString.split(" ")) {
                            tilingSet.add(Integer.parseInt(tilingSetMember.trim()));
                        }
                        tilingSets.add(tilingSet);
                    }
                    sensorLayout.setTilingSets(tilingSets);
                    continue;
                }
                if (sensorLayoutChild.getNodeName().equals("neighbors")) {
                    ArrayList<Neighbor> neighbors = new ArrayList<Neighbor>();
                    for (Node neighborsChild = sensorLayoutChild.getFirstChild(); neighborsChild != null; neighborsChild = neighborsChild.getNextSibling()) {
                        if (!neighborsChild.getNodeName().equals("ch")) continue;
                        try {
                            String[] parts2;
                            Neighbor neighbor = new Neighbor();
                            neighbor.setChannelNumber(Integer.parseInt(XMLUtil.getAttribute(neighborsChild, "n")));
                            String neighborsForNeighborString = neighborsChild.getTextContent();
                            if (neighborsForNeighborString == null) continue;
                            ArrayList<Integer> neighborsForNeighbor = new ArrayList<Integer>();
                            for (String neighborForNeighbor : parts2 = neighborsForNeighborString.split(" ")) {
                                neighborsForNeighbor.add(Integer.parseInt(neighborForNeighbor.trim()));
                            }
                            neighbor.setNeighbors(neighborsForNeighbor);
                            neighbors.add(neighbor);
                            continue;
                        }
                        catch (Exception exp) {
                            System.out.println("XMLLocalFileResource: error: could not add neighbor set: " + exp.getClass());
                        }
                    }
                    sensorLayout.setNeighbors(neighbors);
                    continue;
                }
                if (sensorLayoutChild.getNodeName().equals("originalLayout")) {
                    sensorLayout.setOriginalLayout(sensorLayoutChild.getTextContent());
                    continue;
                }
                if (!sensorLayoutChild.getNodeName().equals("spaces")) continue;
                ArrayList<Integer> spaces = new ArrayList<Integer>();
                for (Node spaceChild = sensorLayoutChild.getFirstChild(); spaceChild != null; spaceChild = spaceChild.getNextSibling()) {
                    if (!spaceChild.getNodeName().equals("space")) continue;
                    spaces.add(new Integer(spaceChild.getTextContent()));
                }
                sensorLayout.setSpaces(spaces);
            }
            return rVal;
        }
        if (toObject instanceof Epochs) {
            Epochs epochs = (Epochs)toObject;
            ArrayList<Epoch> epochList = new ArrayList<Epoch>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root5 = document.getDocumentElement();
            if (root5 != null) {
                root5.normalize();
            }
            if (!root5.getNodeName().equals("epochs")) return rVal;
            for (Node epochsChild = root5.getFirstChild(); epochsChild != null; epochsChild = epochsChild.getNextSibling()) {
                if (!epochsChild.getNodeName().equals("epoch")) continue;
                Epoch epoch = new Epoch();
                for (Node epochChild = epochsChild.getFirstChild(); epochChild != null; epochChild = epochChild.getNextSibling()) {
                    if (epochChild.getNodeName().equals("beginTime")) {
                        epoch.setBeginTime(Long.parseLong(epochChild.getTextContent()));
                        continue;
                    }
                    if (epochChild.getNodeName().equals("endTime")) {
                        epoch.setEndTime(Long.parseLong(epochChild.getTextContent()));
                        continue;
                    }
                    if (epochChild.getNodeName().equals("firstBlock")) {
                        epoch.setFirstBlock(Long.parseLong(epochChild.getTextContent()));
                        continue;
                    }
                    if (!epochChild.getNodeName().equals("lastBlock")) continue;
                    epoch.setLastBlock(Long.parseLong(epochChild.getTextContent()));
                }
                epochList.add(epoch);
            }
            epochs.setEpochs(epochList);
            return rVal;
        }
        if (toObject instanceof EventTrack) {
            EventTrack eventTrack = (EventTrack)toObject;
            ArrayList<Event> events = new ArrayList<Event>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root6 = document.getDocumentElement();
            if (root6 != null) {
                root6.normalize();
            }
            if (!root6.getNodeName().equals("eventTrack")) return rVal;
            for (Node eventTrackChild = root6.getFirstChild(); eventTrackChild != null; eventTrackChild = eventTrackChild.getNextSibling()) {
                if (eventTrackChild.getNodeName().equals("name")) {
                    eventTrack.setName(eventTrackChild.getTextContent());
                    continue;
                }
                if (eventTrackChild.getNodeName().equals("trackType")) {
                    eventTrack.setTrackType(eventTrackChild.getTextContent());
                    continue;
                }
                if (!eventTrackChild.getNodeName().equals("event")) continue;
                Event event = new Event();
                for (Node eventChild = eventTrackChild.getFirstChild(); eventChild != null; eventChild = eventChild.getNextSibling()) {
                    if (eventChild.getNodeName().equals("beginTime")) {
                        event.setBeginTime(eventChild.getTextContent());
                        continue;
                    }
                    if (eventChild.getNodeName().equals("relativeBeginTime")) {
                        event.setRelativeBeginTime(Long.parseLong(eventChild.getTextContent()));
                        continue;
                    }
                    if (eventChild.getNodeName().equals("duration")) {
                        event.setDuration(Long.parseLong(eventChild.getTextContent()));
                        continue;
                    }
                    if (eventChild.getNodeName().equals("code")) {
                        event.setCode(eventChild.getTextContent());
                        continue;
                    }
                    if (eventChild.getNodeName().equals("label")) {
                        event.setLabel(eventChild.getTextContent());
                        continue;
                    }
                    if (eventChild.getNodeName().equals("description")) {
                        event.setDescription(eventChild.getTextContent());
                        continue;
                    }
                    if (eventChild.getNodeName().equals("sourceDevice")) {
                        event.setSourceDevice(eventChild.getTextContent());
                        continue;
                    }
                    if (eventChild.getNodeName().equals("segmentationEvent")) {
                        if (eventChild.getTextContent().compareTo("true") == 0) {
                            event.setSegmentationEvent(true);
                            continue;
                        }
                        event.setSegmentationEvent(false);
                        continue;
                    }
                    if (!eventChild.getNodeName().equals("keys")) continue;
                    ArrayList<Key> keys = new ArrayList<Key>();
                    for (Node keysChild = eventChild.getFirstChild(); keysChild != null; keysChild = keysChild.getNextSibling()) {
                        if (!keysChild.getNodeName().equals("key")) continue;
                        Key key = new Key();
                        for (Node keyChild = keysChild.getFirstChild(); keyChild != null; keyChild = keyChild.getNextSibling()) {
                            if (keyChild.getNodeName().equals("keyCode")) {
                                key.setCode(keyChild.getTextContent());
                                continue;
                            }
                            if (keyChild.getNodeName().equals("description")) {
                                key.setDescription(keyChild.getTextContent());
                                continue;
                            }
                            if (!keyChild.getNodeName().equals("data")) continue;
                            key.setDataType(XMLUtil.getAttribute(keyChild, "dataType"));
                            key.setData(keyChild.getTextContent());
                        }
                        keys.add(key);
                    }
                    event.setKeys(keys);
                }
                events.add(event);
            }
            eventTrack.setEvents(events);
            return rVal;
        }
        if (toObject instanceof History) {
            History history = (History)toObject;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document != null) {
                Element root7 = document.getDocumentElement();
                if (root7 != null) {
                    root7.normalize();
                }
                if (root7.getNodeName().equals("historyEntries")) {
                    for (Node historyEntriesChild = root7.getFirstChild(); historyEntriesChild != null; historyEntriesChild = historyEntriesChild.getNextSibling()) {
                        if (!historyEntriesChild.getNodeName().equals("entry")) continue;
                        Entry entry = new Entry();
                        for (Node entryChild = historyEntriesChild.getFirstChild(); entryChild != null; entryChild = entryChild.getNextSibling()) {
                            if (!entryChild.getNodeName().equals("tool")) continue;
                            Tool tool = new Tool();
                            for (Node toolChild = entryChild.getFirstChild(); toolChild != null; toolChild = toolChild.getNextSibling()) {
                                if (toolChild.getNodeName().equals("name")) {
                                    tool.setName(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("kind")) {
                                    tool.setKind(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("method")) {
                                    tool.setMethod(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("version")) {
                                    tool.setVersion(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("beginTime")) {
                                    tool.setBeginTime(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("endTime")) {
                                    tool.setEndTime(toolChild.getTextContent());
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("sourceFiles")) {
                                    ArrayList<FilePath> sourceFiles = new ArrayList<FilePath>();
                                    for (Node sourceFilesChild = toolChild.getFirstChild(); sourceFilesChild != null; sourceFilesChild = sourceFilesChild.getNextSibling()) {
                                        if (!sourceFilesChild.getNodeName().equals("filePath")) continue;
                                        FilePath filePath = new FilePath();
                                        filePath.setFilePath(sourceFilesChild.getTextContent());
                                        filePath.setType(XMLUtil.getAttribute(sourceFilesChild, "type"));
                                        filePath.setCreator(XMLUtil.getAttribute(sourceFilesChild, "creator"));
                                        sourceFiles.add(filePath);
                                    }
                                    tool.setSourceFiles(sourceFiles);
                                    continue;
                                }
                                if (toolChild.getNodeName().equals("settings")) {
                                    ArrayList<String> settings = new ArrayList<String>();
                                    for (Node settingsChild = toolChild.getFirstChild(); settingsChild != null; settingsChild = settingsChild.getNextSibling()) {
                                        if (!settingsChild.getNodeName().equals("setting")) continue;
                                        settings.add(settingsChild.getTextContent());
                                    }
                                    tool.setSettings(settings);
                                    continue;
                                }
                                if (!toolChild.getNodeName().equals("results")) continue;
                                ArrayList<String> results = new ArrayList<String>();
                                for (Node resultsChild = toolChild.getFirstChild(); resultsChild != null; resultsChild = resultsChild.getNextSibling()) {
                                    if (!resultsChild.getNodeName().equals("result")) continue;
                                    results.add(resultsChild.getTextContent());
                                }
                                tool.setResults(results);
                            }
                            entry.setEntry(tool);
                            entry.setType("tool");
                        }
                        entries.add(entry);
                    }
                }
            }
            history.setEntries(entries);
            return rVal;
        }
        if (toObject instanceof Info) {
            Info info = (Info)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root8 = document.getDocumentElement();
            if (root8 != null) {
                root8.normalize();
            }
            if (!root8.getNodeName().equals("fileInfo")) return rVal;
            for (Node fileInfoChild = root8.getFirstChild(); fileInfoChild != null; fileInfoChild = fileInfoChild.getNextSibling()) {
                if (fileInfoChild.getNodeName().equals("mffVersion")) {
                    info.setMFFVersion(Integer.parseInt(fileInfoChild.getTextContent()));
                    continue;
                }
                if (fileInfoChild.getNodeName().equals("recordTime")) {
                    info.setRecordTime(fileInfoChild.getTextContent());
                    continue;
                }
                if (fileInfoChild.getNodeName().equals("ampSerialNumber")) {
                    info.setAmpSerialNumber(fileInfoChild.getTextContent());
                    continue;
                }
                if (fileInfoChild.getNodeName().equals("ampFirmwareVersion")) {
                    info.setAmpFirmwareVersion(fileInfoChild.getTextContent());
                    continue;
                }
                if (fileInfoChild.getNodeName().equals("movieDelta")) {
                    info.setMovieDelta(Long.parseLong(fileInfoChild.getTextContent()));
                    continue;
                }
                if (fileInfoChild.getNodeName().equals("ampType")) {
                    info.setAmpType(fileInfoChild.getTextContent());
                    continue;
                }
                if (!fileInfoChild.getNodeName().equals("acquisitionVersion")) continue;
                info.setAcquisitionVersionNumber(fileInfoChild.getTextContent());
            }
            return rVal;
        }
        if (toObject instanceof InfoN) {
            InfoN infoN = (InfoN)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root9 = document.getDocumentElement();
            if (root9 != null) {
                root9.normalize();
            }
            if (!root9.getNodeName().equals("dataInfo")) return rVal;
            for (Node dataInfoChild = root9.getFirstChild(); dataInfoChild != null; dataInfoChild = dataInfoChild.getNextSibling()) {
                if (dataInfoChild.getNodeName().equals("generalInformation")) {
                    for (Node generalInformationChild = dataInfoChild.getFirstChild(); generalInformationChild != null; generalInformationChild = generalInformationChild.getNextSibling()) {
                        if (generalInformationChild.getNodeName().equals("fileDataType")) {
                            for (Node fileDataTypeChild = generalInformationChild.getFirstChild(); fileDataTypeChild != null; fileDataTypeChild = fileDataTypeChild.getNextSibling()) {
                                if (fileDataTypeChild.getNodeName().equals("EEG")) {
                                    InfoNFileTypeEEG infoNFileTypeEEG = new InfoNFileTypeEEG();
                                    for (Node eegChild = fileDataTypeChild.getFirstChild(); eegChild != null; eegChild = eegChild.getNextSibling()) {
                                        if (eegChild.getNodeName().equals("sensorLayoutName")) {
                                            infoNFileTypeEEG.setSensorLayoutName(eegChild.getTextContent());
                                            continue;
                                        }
                                        if (eegChild.getNodeName().equals("montageName")) {
                                            infoNFileTypeEEG.setMontageName(eegChild.getTextContent());
                                            continue;
                                        }
                                        if (!eegChild.getNodeName().equals("referenceScheme")) continue;
                                        infoNFileTypeEEG.setReferenceScheme(eegChild.getTextContent());
                                    }
                                    infoN.setInfoNFileTypeInformation(infoNFileTypeEEG);
                                    infoN.setInfoNFileType(InfoN.InfoNFileType.kEEG);
                                    continue;
                                }
                                if (fileDataTypeChild.getNodeName().equals("Spectral")) {
                                    InfoNFileTypeSpectral infoNFileTypeSpectral = new InfoNFileTypeSpectral();
                                    for (Node spectralChild = fileDataTypeChild.getFirstChild(); spectralChild != null; spectralChild = spectralChild.getNextSibling()) {
                                        if (spectralChild.getNodeName().equals("sensorLayoutName")) {
                                            infoNFileTypeSpectral.setSensorLayoutName(spectralChild.getTextContent());
                                            continue;
                                        }
                                        if (spectralChild.getNodeName().equals("montageName")) {
                                            infoNFileTypeSpectral.setMontageName(spectralChild.getTextContent());
                                            continue;
                                        }
                                        if (spectralChild.getNodeName().equals("deltaF")) {
                                            infoNFileTypeSpectral.setDeltaF(Double.valueOf(spectralChild.getTextContent()));
                                            continue;
                                        }
                                        if (spectralChild.getNodeName().equals("path")) {
                                            infoNFileTypeSpectral.setPath(spectralChild.getTextContent());
                                            continue;
                                        }
                                        if (spectralChild.getNodeName().equals("beginTime")) {
                                            infoNFileTypeSpectral.setBeginTime(Long.valueOf(spectralChild.getTextContent()));
                                            continue;
                                        }
                                        if (spectralChild.getNodeName().equals("endTime")) {
                                            infoNFileTypeSpectral.setEndTime(Long.valueOf(spectralChild.getTextContent()));
                                            continue;
                                        }
                                        if (spectralChild.getNodeName().equals("minX")) {
                                            infoNFileTypeSpectral.setMinX(Float.valueOf(spectralChild.getTextContent()).floatValue());
                                            continue;
                                        }
                                        if (spectralChild.getNodeName().equals("maxX")) {
                                            infoNFileTypeSpectral.setMaxX(Float.valueOf(spectralChild.getTextContent()).floatValue());
                                            continue;
                                        }
                                        if (spectralChild.getNodeName().equals("minY")) {
                                            infoNFileTypeSpectral.setMinY(Float.valueOf(spectralChild.getTextContent()).floatValue());
                                            continue;
                                        }
                                        if (!spectralChild.getNodeName().equals("maxY")) continue;
                                        infoNFileTypeSpectral.setMaxY(Float.valueOf(spectralChild.getTextContent()).floatValue());
                                    }
                                    infoN.setInfoNFileTypeInformation(infoNFileTypeSpectral);
                                    infoN.setInfoNFileType(InfoN.InfoNFileType.kSpectral);
                                    continue;
                                }
                                if (fileDataTypeChild.getNodeName().equals("SourceData")) {
                                    InfoNFileTypeSourceData infoNFileTypeSourceData = new InfoNFileTypeSourceData();
                                    for (Node sourceDataChild = fileDataTypeChild.getFirstChild(); sourceDataChild != null; sourceDataChild = sourceDataChild.getNextSibling()) {
                                        if (sourceDataChild.getNodeName().equals("dipoleSetName")) {
                                            infoNFileTypeSourceData.setDipoleSetName(sourceDataChild.getTextContent());
                                            continue;
                                        }
                                        if (!sourceDataChild.getNodeName().equals("numberOfOrientation")) continue;
                                        infoNFileTypeSourceData.setNumberOfOrientation(Long.valueOf(sourceDataChild.getTextContent()));
                                    }
                                    infoN.setInfoNFileTypeInformation(infoNFileTypeSourceData);
                                    infoN.setInfoNFileType(InfoN.InfoNFileType.kSourceData);
                                    continue;
                                }
                                if (fileDataTypeChild.getNodeName().equals("PNSData")) {
                                    InfoNFileTypePNSData infoNFileTypePNSData = new InfoNFileTypePNSData();
                                    for (Node pnsDataChild = fileDataTypeChild.getFirstChild(); pnsDataChild != null; pnsDataChild = pnsDataChild.getNextSibling()) {
                                        if (!pnsDataChild.getNodeName().equals("pnsSetName")) continue;
                                        infoNFileTypePNSData.setPNSSetName(pnsDataChild.getTextContent());
                                    }
                                    infoN.setInfoNFileTypeInformation(infoNFileTypePNSData);
                                    infoN.setInfoNFileType(InfoN.InfoNFileType.kPNSData);
                                    continue;
                                }
                                if (fileDataTypeChild.getNodeName().equals("JTF")) {
                                    InfoNFileTypeJTF infoNFileTypeJTF = new InfoNFileTypeJTF();
                                    for (Node jtfChild = fileDataTypeChild.getFirstChild(); jtfChild != null; jtfChild = jtfChild.getNextSibling()) {
                                        if (jtfChild.getNodeName().equals("sensorLayoutName")) {
                                            infoNFileTypeJTF.setSensorLayoutName(jtfChild.getTextContent());
                                            continue;
                                        }
                                        if (jtfChild.getNodeName().equals("montageName")) {
                                            infoNFileTypeJTF.setMontageName(jtfChild.getTextContent());
                                            continue;
                                        }
                                        if (jtfChild.getNodeName().equals("path")) {
                                            infoNFileTypeJTF.setPath(jtfChild.getTextContent());
                                            continue;
                                        }
                                        if (!jtfChild.getNodeName().equals("samplingRate")) continue;
                                        infoNFileTypeJTF.setSamplingRate(Long.valueOf(jtfChild.getTextContent()));
                                    }
                                    infoN.setInfoNFileTypeInformation(infoNFileTypeJTF);
                                    infoN.setInfoNFileType(InfoN.InfoNFileType.kJTF);
                                    continue;
                                }
                                if (!fileDataTypeChild.getNodeName().equals("TValues")) continue;
                                InfoNFileTypeTValues infoNFileTypeTValues = new InfoNFileTypeTValues();
                                for (Node tValuesChild = fileDataTypeChild.getFirstChild(); tValuesChild != null; tValuesChild = tValuesChild.getNextSibling()) {
                                    if (tValuesChild.getNodeName().equals("sensorLayoutName")) {
                                        infoNFileTypeTValues.setSensorLayoutName(tValuesChild.getTextContent());
                                        continue;
                                    }
                                    if (!tValuesChild.getNodeName().equals("montageName")) continue;
                                    infoNFileTypeTValues.setMontageName(tValuesChild.getTextContent());
                                }
                                infoN.setInfoNFileTypeInformation(infoNFileTypeTValues);
                                infoN.setInfoNFileType(InfoN.InfoNFileType.kTValues);
                            }
                            continue;
                        }
                        if (!generalInformationChild.getNodeName().equals("continuation")) continue;
                        String type = XMLUtil.getAttribute(generalInformationChild, "type");
                        if (type.equals("from")) {
                            infoN.setContinuationFrom(generalInformationChild.getTextContent());
                            continue;
                        }
                        if (!type.equals("to")) continue;
                        infoN.setContinuationTo(generalInformationChild.getTextContent());
                    }
                    continue;
                }
                if (dataInfoChild.getNodeName().equals("hardwareFilterAdjusted")) {
                    String filterString = dataInfoChild.getTextContent();
                    if (filterString.equals("true")) {
                        infoN.setFilterAdjusted(true);
                        infoN.setShiftValue(Integer.parseInt(XMLUtil.getAttribute(dataInfoChild, "shiftMicroseconds")));
                        continue;
                    }
                    infoN.setFilterAdjusted(false);
                    continue;
                }
                if (dataInfoChild.getNodeName().equals("channels")) {
                    ChannelStatus chanStatus = new ChannelStatus();
                    chanStatus.setExclusion(XMLUtil.getAttribute(dataInfoChild, "exclusion"));
                    String channelList = dataInfoChild.getTextContent();
                    ArrayList<Integer> chanList = new ArrayList<Integer>();
                    if (!channelList.isEmpty()) {
                        String[] channelNum;
                        channelList = channelList.replaceAll("\\n", "");
                        for (String cNum : channelNum = channelList.split(" ")) {
                            chanList.add(new Integer(cNum));
                        }
                    }
                    chanStatus.setChannels(chanList);
                    infoN.setChannelStatus(chanStatus);
                    continue;
                }
                if (dataInfoChild.getNodeName().equals("filters")) {
                    ArrayList<Filter> filters = new ArrayList<Filter>();
                    for (Node filterChild = dataInfoChild.getFirstChild(); filterChild != null; filterChild = filterChild.getNextSibling()) {
                        if (!filterChild.getNodeName().equals("filter")) continue;
                        Filter filter = new Filter();
                        for (Node filterNode = filterChild.getFirstChild(); filterNode != null; filterNode = filterNode.getNextSibling()) {
                            if (filterNode.getNodeName().equals("beginTime")) {
                                filter.setBeginTime(Long.parseLong(filterNode.getTextContent()));
                                continue;
                            }
                            if (filterNode.getNodeName().equals("endTime")) {
                                filter.setEndTime(Long.parseLong(filterNode.getTextContent()));
                                continue;
                            }
                            if (filterNode.getNodeName().equals("method")) {
                                filter.setMethod(filterNode.getTextContent());
                                continue;
                            }
                            if (filterNode.getNodeName().equals("type")) {
                                filter.setType(filterNode.getTextContent());
                                continue;
                            }
                            if (filterNode.getNodeName().equals("samplingFrequency")) {
                                filter.setSamplingFrequency(Double.parseDouble(filterNode.getTextContent()));
                                filter.setSamplingFrequencyUnits(XMLUtil.getAttribute(filterNode, "units"));
                                continue;
                            }
                            if (filterNode.getNodeName().equals("cutoffFrequency")) {
                                filter.setCutoffFrequency(Double.parseDouble(filterNode.getTextContent()));
                                filter.setCutoffFrequencyUnits(XMLUtil.getAttribute(filterNode, "units"));
                                continue;
                            }
                            if (!filterNode.getNodeName().equals("passbandAttenuation")) continue;
                            filter.setPassbandAttenuation(Double.parseDouble(filterNode.getTextContent()));
                            filter.setPassbandAttenuationUnits(XMLUtil.getAttribute(filterNode, "units"));
                        }
                        filters.add(filter);
                    }
                    infoN.setFilters(filters);
                    continue;
                }
                if (!dataInfoChild.getNodeName().equals("calibrations")) continue;
                ArrayList<Calibration> calibrations = new ArrayList<Calibration>();
                for (Node calChild = dataInfoChild.getFirstChild(); calChild != null; calChild = calChild.getNextSibling()) {
                    if (!calChild.getNodeName().equals("calibration")) continue;
                    Calibration calibration = new Calibration();
                    for (Node calibrationChild = calChild.getFirstChild(); calibrationChild != null; calibrationChild = calibrationChild.getNextSibling()) {
                        if (calibrationChild.getNodeName().equals("beginTime")) {
                            calibration.setBeginTime(Long.parseLong(calibrationChild.getTextContent()));
                            continue;
                        }
                        if (calibrationChild.getNodeName().equals("endTime")) {
                            calibration.setEndTime(Long.parseLong(calibrationChild.getTextContent()));
                            continue;
                        }
                        if (calibrationChild.getNodeName().equals("type")) {
                            calibration.setType(calibrationChild.getTextContent());
                            continue;
                        }
                        if (!calibrationChild.getNodeName().equals("channels")) continue;
                        ArrayList<Channel> channels = new ArrayList<Channel>();
                        for (Node channelNode = calibrationChild.getFirstChild(); channelNode != null; channelNode = channelNode.getNextSibling()) {
                            if (!channelNode.getNodeName().equals("ch")) continue;
                            Channel channel = new Channel();
                            channel.setChannelNumber(Integer.parseInt(XMLUtil.getAttribute(channelNode, "n")));
                            channel.setChannelData(channelNode.getTextContent());
                            channels.add(channel);
                        }
                        calibration.setChannels(channels);
                    }
                    calibrations.add(calibration);
                }
                infoN.setCalibrations(calibrations);
            }
            return rVal;
        }
        if (toObject instanceof Subject) {
            Subject subject = (Subject)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root10 = document.getDocumentElement();
            if (root10 != null) {
                root10.normalize();
            }
            if (!root10.getNodeName().equals("patient")) return rVal;
            for (Node patientChild = root10.getFirstChild(); patientChild != null; patientChild = patientChild.getNextSibling()) {
                if (patientChild.getNodeName().equals("fields")) {
                    ArrayList<Field> fields = new ArrayList<Field>();
                    for (Node fieldsChild = patientChild.getFirstChild(); fieldsChild != null; fieldsChild = fieldsChild.getNextSibling()) {
                        if (!fieldsChild.getNodeName().equals("field")) continue;
                        Field field = new Field();
                        for (Node fieldChild = fieldsChild.getFirstChild(); fieldChild != null; fieldChild = fieldChild.getNextSibling()) {
                            if (fieldChild.getNodeName().equals("name")) {
                                field.setName(fieldChild.getTextContent());
                                continue;
                            }
                            if (fieldChild.getNodeName().equals("data")) {
                                field.setData(fieldChild.getTextContent());
                                field.setDataType(XMLUtil.getAttribute(fieldChild, "dataType"));
                                continue;
                            }
                            if (!fieldChild.getNodeName().equals("choices")) continue;
                            field.setChoices(fieldChild.getTextContent());
                        }
                        fields.add(field);
                    }
                    subject.setFields(fields);
                    continue;
                }
                if (!patientChild.getNodeName().equals("mris")) continue;
                ArrayList<String> mris = new ArrayList<String>();
                for (Node mrisChild = patientChild.getFirstChild(); mrisChild != null; mrisChild = mrisChild.getNextSibling()) {
                    if (!mrisChild.getNodeName().equals("fileName")) continue;
                    mris.add(mrisChild.getTextContent());
                }
                subject.setMRIS(mris);
            }
            return rVal;
        }
        if (toObject instanceof PNSSet) {
            Element root11;
            PNSSet pnsSet = (PNSSet)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null || (root11 = document.getDocumentElement()) == null) return rVal;
            root11.normalize();
            if (!root11.getNodeName().equals("PNSSet")) return rVal;
            for (Node pnsSetChild = root11.getFirstChild(); pnsSetChild != null; pnsSetChild = pnsSetChild.getNextSibling()) {
                if (pnsSetChild.getNodeName().equals("name")) {
                    pnsSet.setName(pnsSetChild.getTextContent());
                    continue;
                }
                if (pnsSetChild.getNodeName().equals("ampSeries")) {
                    pnsSet.setAmpSeries(pnsSetChild.getTextContent());
                    continue;
                }
                if (!pnsSetChild.getNodeName().equals("sensors")) continue;
                ArrayList<PNSSensor> sensors = new ArrayList<PNSSensor>();
                for (Node sensorsChild = pnsSetChild.getFirstChild(); sensorsChild != null; sensorsChild = sensorsChild.getNextSibling()) {
                    if (!sensorsChild.getNodeName().equals("sensor")) continue;
                    PNSSensor sensor = new PNSSensor();
                    for (Node sensorChild = sensorsChild.getFirstChild(); sensorChild != null; sensorChild = sensorChild.getNextSibling()) {
                        if (sensorChild.getNodeName().equals("name")) {
                            sensor.setName(sensorChild.getTextContent());
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("number")) {
                            sensor.setNumber(Integer.parseInt(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("unit")) {
                            sensor.setUnit(sensorChild.getTextContent());
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("sensorType")) {
                            sensor.setSensorType(sensorChild.getTextContent());
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("psgType")) {
                            sensor.setPSGType(Integer.parseInt(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("mapping")) {
                            sensor.setMapping(Integer.parseInt(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("samplingRate")) {
                            sensor.setSamplingRate(Long.parseLong(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("highpass")) {
                            sensor.setHighpass(Double.parseDouble(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("lowpass")) {
                            sensor.setLowpass(Double.parseDouble(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("notch")) {
                            sensor.setNotch(Double.parseDouble(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("groupNumber")) {
                            sensor.setGroupNumber(Integer.parseInt(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("conversion")) {
                            sensor.setConversion(Integer.parseInt(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("gain")) {
                            sensor.setGain(Float.parseFloat(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("defaultDisplayAmplitude")) {
                            sensor.setDefaultAmplitude(Float.parseFloat(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("highpassDisplay")) {
                            sensor.setDefaultDisplayHighpass(Double.parseDouble(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("lowpassDisplay")) {
                            sensor.setDefaultDisplayLowpass(Double.parseDouble(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("notchDisplay")) {
                            sensor.setDefaultDisplayNotch(Double.parseDouble(sensorChild.getTextContent()));
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("color")) {
                            sensor.setColorString(sensorChild.getTextContent());
                            continue;
                        }
                        if (!sensorChild.getNodeName().equals("positiveUp")) continue;
                        if (sensorChild.getTextContent().compareTo("true") == 0) {
                            sensor.setPositiveUp(true);
                            continue;
                        }
                        sensor.setPositiveUp(false);
                    }
                    sensors.add(sensor);
                }
                pnsSet.setPNSSensors(sensors);
            }
            return rVal;
        }
        if (toObject instanceof DipoleSet) {
            Element root12;
            DipoleSet dipoleSet = (DipoleSet)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null || (root12 = document.getDocumentElement()) == null) return rVal;
            root12.normalize();
            if (!root12.getNodeName().equals("dipoleSet")) return rVal;
            for (Node dipoleSetChild = root12.getFirstChild(); dipoleSetChild != null; dipoleSetChild = dipoleSetChild.getNextSibling()) {
                float[] coords;
                List<String> items;
                String coordString;
                Node sensorChild;
                Dipole dipole;
                Node sensorsChild;
                ArrayList<Dipole> theDipoles;
                if (dipoleSetChild.getNodeName().equals("name")) {
                    dipoleSet.setName(dipoleSetChild.getTextContent());
                    continue;
                }
                if (dipoleSetChild.getNodeName().equals("type")) {
                    dipoleSet.setType(dipoleSetChild.getTextContent());
                    continue;
                }
                if (dipoleSetChild.getNodeName().equals("subjectID")) {
                    dipoleSet.setSubjectID(dipoleSetChild.getTextContent());
                    continue;
                }
                if (dipoleSetChild.getNodeName().equals("dipoles")) {
                    theDipoles = new ArrayList<Dipole>();
                    for (sensorsChild = dipoleSetChild.getFirstChild(); sensorsChild != null; sensorsChild = sensorsChild.getNextSibling()) {
                        if (!sensorsChild.getNodeName().equals("dipole")) continue;
                        dipole = new Dipole();
                        for (sensorChild = sensorsChild.getFirstChild(); sensorChild != null; sensorChild = sensorChild.getNextSibling()) {
                            if (sensorChild.getNodeName().equals("name")) {
                                dipole.setName(sensorChild.getTextContent());
                                continue;
                            }
                            if (sensorChild.getNodeName().equals("computationCoordinate")) {
                                coordString = sensorChild.getTextContent();
                                items = Arrays.asList(coordString.split("\\s*,\\s*"));
                                coords = new float[]{Float.parseFloat(items.get(0)), Float.parseFloat(items.get(1)), Float.parseFloat(items.get(2))};
                                dipole.setComputationLocation(coords);
                                continue;
                            }
                            if (!sensorChild.getNodeName().equals("visualizationCoordinate")) continue;
                            coordString = sensorChild.getTextContent();
                            items = Arrays.asList(coordString.split("\\s*,\\s*"));
                            coords = new float[]{Float.parseFloat(items.get(0)), Float.parseFloat(items.get(1)), Float.parseFloat(items.get(2))};
                            dipole.setVisualizationLocation(coords);
                        }
                        theDipoles.add(dipole);
                    }
                    dipoleSet.setDipoles(theDipoles);
                    continue;
                }
                if (!dipoleSetChild.getNodeName().equals("fidutial")) continue;
                theDipoles = new ArrayList();
                for (sensorsChild = dipoleSetChild.getFirstChild(); sensorsChild != null; sensorsChild = sensorsChild.getNextSibling()) {
                    if (!sensorsChild.getNodeName().equals("dipole")) continue;
                    dipole = new Dipole();
                    for (sensorChild = sensorsChild.getFirstChild(); sensorChild != null; sensorChild = sensorChild.getNextSibling()) {
                        if (sensorChild.getNodeName().equals("name")) {
                            dipole.setName(sensorChild.getTextContent());
                            continue;
                        }
                        if (sensorChild.getNodeName().equals("computationCoordinate")) {
                            coordString = sensorChild.getTextContent();
                            items = Arrays.asList(coordString.split("\\s*,\\s*"));
                            coords = new float[]{Float.parseFloat(items.get(0)), Float.parseFloat(items.get(1)), Float.parseFloat(items.get(2))};
                            dipole.setComputationLocation(coords);
                            continue;
                        }
                        if (!sensorChild.getNodeName().equals("visualizationCoordinate")) continue;
                        coordString = sensorChild.getTextContent();
                        items = Arrays.asList(coordString.split("\\s*,\\s*"));
                        coords = new float[]{Float.parseFloat(items.get(0)), Float.parseFloat(items.get(1)), Float.parseFloat(items.get(2))};
                        dipole.setVisualizationLocation(coords);
                    }
                    theDipoles.add(dipole);
                }
                dipoleSet.setFidutials(theDipoles);
            }
            return rVal;
        }
        if (toObject instanceof Fields) {
            Fields theFields = (Fields)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root13 = document.getDocumentElement();
            if (root13 != null) {
                root13.normalize();
            }
            if (!root13.getNodeName().equals("fields")) return rVal;
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Node fieldsChild = root13.getFirstChild(); fieldsChild != null; fieldsChild = fieldsChild.getNextSibling()) {
                if (!fieldsChild.getNodeName().equals("field")) continue;
                Field field = new Field();
                for (Node fieldChild = fieldsChild.getFirstChild(); fieldChild != null; fieldChild = fieldChild.getNextSibling()) {
                    if (fieldChild.getNodeName().equals("name")) {
                        field.setName(fieldChild.getTextContent());
                        continue;
                    }
                    if (fieldChild.getNodeName().equals("data")) {
                        field.setData(fieldChild.getTextContent());
                        field.setDataType(XMLUtil.getAttribute(fieldChild, "dataType"));
                        continue;
                    }
                    if (!fieldChild.getNodeName().equals("choices")) continue;
                    field.setChoices(fieldChild.getTextContent());
                }
                fields.add(field);
            }
            theFields.setFields(fields);
            return rVal;
        }
        if (toObject instanceof Notes) {
            Notes theNotes = (Notes)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root14 = document.getDocumentElement();
            if (root14 != null) {
                root14.normalize();
            }
            if (!root14.getNodeName().equals("notes")) return rVal;
            theNotes.setNotes(root14.getTextContent());
            return rVal;
        }
        if (toObject instanceof JTFCategories) {
            JTFCategories categories = (JTFCategories)toObject;
            ArrayList<JTFCategory> categoryList = new ArrayList<JTFCategory>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root15 = document.getDocumentElement();
            if (root15 != null) {
                root15.normalize();
            }
            if (!root15.getNodeName().equals("jtfCategories")) return rVal;
            for (Node categoriesChild = root15.getFirstChild(); categoriesChild != null; categoriesChild = categoriesChild.getNextSibling()) {
                if (!categoriesChild.getNodeName().equals("cat")) continue;
                JTFCategory category = new JTFCategory();
                for (Node categoryChild = categoriesChild.getFirstChild(); categoryChild != null; categoryChild = categoryChild.getNextSibling()) {
                    if (categoryChild.getNodeName().equals("name")) {
                        category.setName(categoryChild.getTextContent());
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("numberOfSegments")) {
                        category.setNumberOfSegment(Long.parseLong(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("segmentEventTime")) {
                        category.setSegmentEventTime(Long.parseLong(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("duration")) {
                        category.setDuration(Long.parseLong(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("minPower")) {
                        category.setMinPower(Double.parseDouble(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("maxPower")) {
                        category.setMaxPower(Double.parseDouble(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("minPhase")) {
                        category.setMinPhase(Double.parseDouble(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("maxPhase")) {
                        category.setMaxPhase(Double.parseDouble(categoryChild.getTextContent()));
                        continue;
                    }
                    if (!categoryChild.getNodeName().equals("frequencies")) continue;
                    ArrayList<Double> frequencies = new ArrayList<Double>();
                    for (Node segmentsChild = categoryChild.getFirstChild(); segmentsChild != null; segmentsChild = segmentsChild.getNextSibling()) {
                        if (!segmentsChild.getNodeName().equals("freq")) continue;
                        frequencies.add(Double.parseDouble(segmentsChild.getTextContent()));
                    }
                    category.setFrequencies(frequencies);
                }
                categoryList.add(category);
            }
            categories.setCategories(categoryList);
            return rVal;
        }
        if (toObject instanceof MovieSyncs) {
            MovieSyncs movieSyncs = (MovieSyncs)toObject;
            ArrayList<MovieSync> syncList = new ArrayList<MovieSync>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root16 = document.getDocumentElement();
            if (root16 != null) {
                root16.normalize();
            }
            if (!root16.getNodeName().equals("movieSyncs")) return rVal;
            for (Node syncChild = root16.getFirstChild(); syncChild != null; syncChild = syncChild.getNextSibling()) {
                if (!syncChild.getNodeName().equals("movieSync")) continue;
                MovieSync sync = new MovieSync();
                for (Node categoryChild = syncChild.getFirstChild(); categoryChild != null; categoryChild = categoryChild.getNextSibling()) {
                    if (categoryChild.getNodeName().equals("fileName")) {
                        sync.setFileName(categoryChild.getTextContent());
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("sampleBeginTime")) {
                        sync.setSampleBeginTime(Long.parseLong(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("sampleEndTime")) {
                        sync.setSampleEndTime(Long.parseLong(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("videoBeginTime")) {
                        sync.setVideoBeginTime(Double.parseDouble(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("videoEndTime")) {
                        sync.setVideoEndTime(Double.parseDouble(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("category")) {
                        sync.setCategory(Long.parseLong(categoryChild.getTextContent()));
                        continue;
                    }
                    if (!categoryChild.getNodeName().equals("segment")) continue;
                    sync.setSegment(Long.parseLong(categoryChild.getTextContent()));
                }
                syncList.add(sync);
            }
            movieSyncs.setMovieSyncs(syncList);
            return rVal;
        }
        if (toObject instanceof PhoticStimRunFile) {
            PhoticStimRunFile runFile = (PhoticStimRunFile)toObject;
            ArrayList<PhoticStimSequence> sequences = new ArrayList<PhoticStimSequence>();
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null) return rVal;
            Element root17 = document.getDocumentElement();
            if (root17 != null) {
                root17.normalize();
            }
            if (!root17.getNodeName().equals("photicStimRun")) return rVal;
            for (Node syncChild = root17.getFirstChild(); syncChild != null; syncChild = syncChild.getNextSibling()) {
                if (!syncChild.getNodeName().equals("frequencyTrainRun")) continue;
                PhoticStimSequence train = new PhoticStimSequence();
                for (Node categoryChild = syncChild.getFirstChild(); categoryChild != null; categoryChild = categoryChild.getNextSibling()) {
                    if (categoryChild.getNodeName().equals("name")) {
                        train.setName(categoryChild.getTextContent());
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("beginTime")) {
                        train.setBeginTime(Long.parseLong(categoryChild.getTextContent()));
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("useStartEvent")) {
                        if (categoryChild.getTextContent().compareTo("true") == 0) {
                            train.setUseStartEvent(true);
                            continue;
                        }
                        train.setUseStartEvent(false);
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("startEvent")) {
                        train.setStartEventLabel(categoryChild.getTextContent());
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("useEndEvent")) {
                        if (categoryChild.getTextContent().compareTo("true") == 0) {
                            train.setUseEndEvent(true);
                            continue;
                        }
                        train.setUseEndEvent(false);
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("endEvent")) {
                        train.setEndEventLabel(categoryChild.getTextContent());
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("useFlashEvent")) {
                        if (categoryChild.getTextContent().compareTo("true") == 0) {
                            train.setUseFlashEvent(true);
                            continue;
                        }
                        train.setUseFlashEvent(false);
                        continue;
                    }
                    if (categoryChild.getNodeName().equals("flashEvent")) {
                        train.setFlashEventLabel(categoryChild.getTextContent());
                        continue;
                    }
                    if (!categoryChild.getNodeName().equals("frequencyTrain")) continue;
                    ArrayList<PhoticStimFrequency> frequencyTrains = new ArrayList<PhoticStimFrequency>();
                    for (Node psfChild = categoryChild.getFirstChild(); psfChild != null; psfChild = psfChild.getNextSibling()) {
                        if (!psfChild.getNodeName().equals("pulseSequence")) continue;
                        PhoticStimFrequency flashFreq = new PhoticStimFrequency();
                        for (Node trainNode = psfChild.getFirstChild(); trainNode != null; trainNode = trainNode.getNextSibling()) {
                            if (trainNode.getNodeName().equals("frequency")) {
                                flashFreq.setFrequency(Float.parseFloat(trainNode.getTextContent()));
                                continue;
                            }
                            if (trainNode.getNodeName().equals("duration")) {
                                flashFreq.setDuration(Integer.parseInt(trainNode.getTextContent()));
                                continue;
                            }
                            if (trainNode.getNodeName().equals("rest")) {
                                flashFreq.setRest(Integer.parseInt(trainNode.getTextContent()));
                                continue;
                            }
                            if (!trainNode.getNodeName().equals("repeat")) continue;
                            flashFreq.setRepeatCount(Integer.parseInt(trainNode.getTextContent()));
                        }
                        frequencyTrains.add(flashFreq);
                    }
                    train.setSequences(frequencyTrains);
                }
                sequences.add(train);
            }
            runFile.setSequences(sequences);
            return rVal;
        }
        if (toObject instanceof GeometryEGIG) {
            Element root18;
            GeometryEGIG geometryEGIG = (GeometryEGIG)toObject;
            Document document = XMLUtil.getDocumentFromURI(uri);
            if (document == null || (root18 = document.getDocumentElement()) == null) return rVal;
            root18.normalize();
            if (!root18.getNodeName().equalsIgnoreCase("EGIXML")) return rVal;
            for (Node egiXMLChild = root18.getFirstChild(); egiXMLChild != null; egiXMLChild = egiXMLChild.getNextSibling()) {
                String pointsEncodingType;
                String pointsDataType;
                Node pointsChild;
                if (egiXMLChild.getNodeName().equalsIgnoreCase("HISTORY")) {
                    ArrayList<String> history = new ArrayList<String>();
                    for (Node historyChild = egiXMLChild.getFirstChild(); historyChild != null; historyChild = historyChild.getNextSibling()) {
                        if (!historyChild.getNodeName().equalsIgnoreCase("EVENT")) continue;
                        history.add(historyChild.getTextContent());
                    }
                    geometryEGIG.setHistory(history);
                    continue;
                }
                if (egiXMLChild.getNodeName().equalsIgnoreCase("SUBJECTINFO")) {
                    SubjectInfo subjectInfo = new SubjectInfo();
                    for (Node subjectInfoChild = egiXMLChild.getFirstChild(); subjectInfoChild != null; subjectInfoChild = subjectInfoChild.getNextSibling()) {
                        if (subjectInfoChild.getNodeName().equalsIgnoreCase("SUBJECTID")) {
                            subjectInfo.setSubjectID(subjectInfoChild.getTextContent());
                            continue;
                        }
                        if (subjectInfoChild.getNodeName().equalsIgnoreCase("MEDICALID")) {
                            subjectInfo.setMedicalID(subjectInfoChild.getTextContent());
                            continue;
                        }
                        if (subjectInfoChild.getNodeName().equalsIgnoreCase("FIRSTNAME")) {
                            subjectInfo.setFirstName(subjectInfoChild.getTextContent());
                            continue;
                        }
                        if (subjectInfoChild.getNodeName().equalsIgnoreCase("LASTNAME")) {
                            subjectInfo.setLastName(subjectInfoChild.getTextContent());
                            continue;
                        }
                        if (subjectInfoChild.getNodeName().equalsIgnoreCase("DOB")) {
                            subjectInfo.setDateOfBirth(subjectInfoChild.getTextContent());
                            continue;
                        }
                        if (!subjectInfoChild.getNodeName().equalsIgnoreCase("SEX")) continue;
                        subjectInfo.setGender(subjectInfoChild.getTextContent());
                    }
                    geometryEGIG.setSubjectInfo(subjectInfo);
                    continue;
                }
                if (egiXMLChild.getNodeName().equalsIgnoreCase("CRANIUMNORMALS")) {
                    CraniumNormals craniumNormals = new CraniumNormals();
                    craniumNormals.setSource(XMLUtil.getAttribute(egiXMLChild, "Source"));
                    for (Node craniumNormalsChild = egiXMLChild.getFirstChild(); craniumNormalsChild != null; craniumNormalsChild = craniumNormalsChild.getNextSibling()) {
                        if (craniumNormalsChild.getNodeName().equalsIgnoreCase("POINTS")) {
                            craniumNormals.setNumberOfNormals(Integer.parseInt(XMLUtil.getAttribute(craniumNormalsChild, "NumPoints")));
                            for (pointsChild = craniumNormalsChild.getFirstChild(); pointsChild != null; pointsChild = pointsChild.getNextSibling()) {
                                if (!pointsChild.getNodeName().equalsIgnoreCase("DATA")) continue;
                                pointsDataType = XMLUtil.getAttribute(pointsChild, "DataType");
                                if (pointsDataType.equals("float")) {
                                    craniumNormals.setPointsDataType(XMLUtil.DataTypes.FLOAT);
                                } else if (pointsDataType.equals("double")) {
                                    craniumNormals.setPointsDataType(XMLUtil.DataTypes.DOUBLE);
                                } else if (pointsDataType.equals("int") || pointsDataType.equals("uint")) {
                                    craniumNormals.setPointsDataType(XMLUtil.DataTypes.INT);
                                }
                                pointsEncodingType = XMLUtil.getAttribute(pointsChild, "Encoding");
                                if (pointsEncodingType.equals("ascii")) {
                                    craniumNormals.setPointsEncodingType(XMLUtil.EncodingTypes.ASCII);
                                } else if (pointsEncodingType.equals("base64")) {
                                    craniumNormals.setPointsEncodingType(XMLUtil.EncodingTypes.BASE64);
                                }
                                craniumNormals.setPointsInflatedSize(Long.parseLong(XMLUtil.getAttribute(pointsChild, "InflatedSize")));
                                craniumNormals.setPointsData(XMLUtil.decodeEncodedString(pointsChild.getTextContent(), craniumNormals.getPointsDataType(), craniumNormals.getPointsEncodingType(), ByteOrder.LITTLE_ENDIAN));
                            }
                            continue;
                        }
                        if (!craniumNormalsChild.getNodeName().equalsIgnoreCase("NORMALS")) continue;
                        craniumNormals.setNumberOfNormals(Integer.parseInt(XMLUtil.getAttribute(craniumNormalsChild, "NumNormals")));
                        for (Node normalsChild = craniumNormalsChild.getFirstChild(); normalsChild != null; normalsChild = normalsChild.getNextSibling()) {
                            if (!normalsChild.getNodeName().equalsIgnoreCase("DATA")) continue;
                            String normalsDataType = XMLUtil.getAttribute(normalsChild, "DataType");
                            if (normalsDataType.equals("float")) {
                                craniumNormals.setNormalsDataType(XMLUtil.DataTypes.FLOAT);
                            } else if (normalsDataType.equals("double")) {
                                craniumNormals.setNormalsDataType(XMLUtil.DataTypes.DOUBLE);
                            } else if (normalsDataType.equals("int") || normalsDataType.equals("uint")) {
                                craniumNormals.setNormalsDataType(XMLUtil.DataTypes.INT);
                            }
                            String normalsEncodingType = XMLUtil.getAttribute(normalsChild, "Encoding");
                            if (normalsEncodingType.equals("ascii")) {
                                craniumNormals.setNormalsEncodingType(XMLUtil.EncodingTypes.ASCII);
                            } else if (normalsEncodingType.equals("base64")) {
                                craniumNormals.setNormalsEncodingType(XMLUtil.EncodingTypes.BASE64);
                            }
                            craniumNormals.setNormalsInflatedSize(Long.parseLong(XMLUtil.getAttribute(normalsChild, "InflatedSize")));
                            craniumNormals.setNormalsData(XMLUtil.decodeEncodedString(normalsChild.getTextContent(), craniumNormals.getNormalsDataType(), craniumNormals.getNormalsEncodingType(), ByteOrder.LITTLE_ENDIAN));
                        }
                    }
                    geometryEGIG.setCraniumNormals(craniumNormals);
                    continue;
                }
                if (egiXMLChild.getNodeName().equalsIgnoreCase("SENSORSET")) {
                    SensorLayout sensorLayout = new SensorLayout();
                    ArrayList<Sensor> sensors = new ArrayList<Sensor>();
                    sensorLayout.setSource(XMLUtil.getAttribute(egiXMLChild, "Source"));
                    for (Node sensorLayoutChild = egiXMLChild.getFirstChild(); sensorLayoutChild != null; sensorLayoutChild = sensorLayoutChild.getNextSibling()) {
                        Sensor sensor = new Sensor();
                        sensor.setName(XMLUtil.getAttribute(sensorLayoutChild, "Name"));
                        for (Node sensorChild = sensorLayoutChild.getFirstChild(); sensorChild != null; sensorChild = sensorChild.getNextSibling()) {
                            if (!sensorChild.getNodeName().equalsIgnoreCase("LOCATION")) continue;
                            for (Node locationChild = sensorChild.getFirstChild(); locationChild != null; locationChild = locationChild.getNextSibling()) {
                                if (locationChild.getNodeName().equalsIgnoreCase("X")) {
                                    sensor.setX(Float.parseFloat(locationChild.getTextContent()));
                                    continue;
                                }
                                if (locationChild.getNodeName().equalsIgnoreCase("Y")) {
                                    sensor.setY(Float.parseFloat(locationChild.getTextContent()));
                                    continue;
                                }
                                if (!locationChild.getNodeName().equalsIgnoreCase("Z")) continue;
                                sensor.setZ(Float.parseFloat(locationChild.getTextContent()));
                            }
                        }
                        sensors.add(sensor);
                    }
                    sensorLayout.setSensors(sensors);
                    geometryEGIG.setSensorLayout(sensorLayout);
                    continue;
                }
                if (egiXMLChild.getNodeName().equalsIgnoreCase("DIPOLESET")) {
                    DipoleSet dipoleSet = new DipoleSet();
                    ArrayList<Dipole> dipoles = new ArrayList<Dipole>();
                    dipoleSet.setSource(XMLUtil.getAttribute(egiXMLChild, "Source"));
                    dipoleSet.setType(XMLUtil.getAttribute(egiXMLChild, "Type"));
                    if (!dipoleSet.getType().equals("Oriented")) continue;
                    for (Node dipoleSetChild = egiXMLChild.getFirstChild(); dipoleSetChild != null; dipoleSetChild = dipoleSetChild.getNextSibling()) {
                        if (!dipoleSetChild.getNodeName().equalsIgnoreCase("DIPOLE")) continue;
                        Dipole dipole = new Dipole();
                        for (Node dipoleChild = dipoleSetChild.getFirstChild(); dipoleChild != null; dipoleChild = dipoleChild.getNextSibling()) {
                            if (dipoleChild.getNodeName().equalsIgnoreCase("Id")) {
                                dipole.setID(Integer.parseInt(dipoleChild.getTextContent()));
                                continue;
                            }
                            if (dipoleChild.getNodeName().equalsIgnoreCase("LOCATION")) {
                                float[] location = new float[]{0.0f, 0.0f, 0.0f};
                                for (Node locationChild = dipoleChild.getFirstChild(); locationChild != null; locationChild = locationChild.getNextSibling()) {
                                    if (locationChild.getNodeName().equalsIgnoreCase("X")) {
                                        location[0] = Float.parseFloat(locationChild.getTextContent());
                                        continue;
                                    }
                                    if (locationChild.getNodeName().equalsIgnoreCase("Y")) {
                                        location[1] = Float.parseFloat(locationChild.getTextContent());
                                        continue;
                                    }
                                    if (!locationChild.getNodeName().equalsIgnoreCase("Z")) continue;
                                    location[2] = Float.parseFloat(locationChild.getTextContent());
                                }
                                dipole.setComputationLocation(location);
                                continue;
                            }
                            if (!dipoleChild.getNodeName().equalsIgnoreCase("DIRECTION")) continue;
                            float[] direction = new float[]{0.0f, 0.0f, 0.0f};
                            for (Node directionChild = dipoleChild.getFirstChild(); directionChild != null; directionChild = directionChild.getNextSibling()) {
                                if (directionChild.getNodeName().equalsIgnoreCase("X")) {
                                    direction[0] = Float.parseFloat(directionChild.getTextContent());
                                    continue;
                                }
                                if (directionChild.getNodeName().equalsIgnoreCase("Y")) {
                                    direction[1] = Float.parseFloat(directionChild.getTextContent());
                                    continue;
                                }
                                if (!directionChild.getNodeName().equalsIgnoreCase("Z")) continue;
                                direction[2] = Float.parseFloat(directionChild.getTextContent());
                            }
                            dipole.setDirection(direction);
                        }
                        dipoles.add(dipole);
                    }
                    System.out.println("number of dipoles: " + dipoles.size());
                    dipoleSet.setDipoles(dipoles);
                    geometryEGIG.setDipoleSet(dipoleSet);
                    continue;
                }
                if (!egiXMLChild.getNodeName().equalsIgnoreCase("TRISURF")) continue;
                TriangleSurface triangleSurface = new TriangleSurface();
                triangleSurface.setName(XMLUtil.getAttribute(egiXMLChild, "Name"));
                triangleSurface.setSource(XMLUtil.getAttribute(egiXMLChild, "Source"));
                triangleSurface.setDataCentering(XMLUtil.getAttribute(egiXMLChild, "DataCentering"));
                for (Node triangleSurfaceChild = egiXMLChild.getFirstChild(); triangleSurfaceChild != null; triangleSurfaceChild = triangleSurfaceChild.getNextSibling()) {
                    if (triangleSurfaceChild.getNodeName().equalsIgnoreCase("POINTS")) {
                        triangleSurface.setNumberOfPoints(Integer.parseInt(XMLUtil.getAttribute(triangleSurfaceChild, "NumPoints")));
                        for (pointsChild = triangleSurfaceChild.getFirstChild(); pointsChild != null; pointsChild = pointsChild.getNextSibling()) {
                            if (!pointsChild.getNodeName().equalsIgnoreCase("DATA")) continue;
                            pointsDataType = XMLUtil.getAttribute(pointsChild, "DataType");
                            if (pointsDataType.equals("float")) {
                                triangleSurface.setPointsDataType(XMLUtil.DataTypes.FLOAT);
                            } else if (pointsDataType.equals("double")) {
                                triangleSurface.setPointsDataType(XMLUtil.DataTypes.DOUBLE);
                            } else if (pointsDataType.equals("int") || pointsDataType.equals("uint")) {
                                triangleSurface.setPointsDataType(XMLUtil.DataTypes.INT);
                            }
                            pointsEncodingType = XMLUtil.getAttribute(pointsChild, "Encoding");
                            if (pointsEncodingType.equals("ascii")) {
                                triangleSurface.setPointsEncodingType(XMLUtil.EncodingTypes.ASCII);
                            } else if (pointsEncodingType.equals("base64")) {
                                triangleSurface.setPointsEncodingType(XMLUtil.EncodingTypes.BASE64);
                            }
                            triangleSurface.setPointsInflatedSize(Long.parseLong(XMLUtil.getAttribute(pointsChild, "InflatedSize")));
                            triangleSurface.setPointsData(XMLUtil.decodeEncodedString(pointsChild.getTextContent(), triangleSurface.getPointsDataType(), triangleSurface.getPointsEncodingType(), ByteOrder.LITTLE_ENDIAN));
                        }
                        continue;
                    }
                    if (triangleSurfaceChild.getNodeName().equalsIgnoreCase("TRIANGLES")) {
                        triangleSurface.setNumberOfTriangles(Integer.parseInt(XMLUtil.getAttribute(triangleSurfaceChild, "NumTris")));
                        for (Node trianglesChild = triangleSurfaceChild.getFirstChild(); trianglesChild != null; trianglesChild = trianglesChild.getNextSibling()) {
                            if (!trianglesChild.getNodeName().equalsIgnoreCase("DATA")) continue;
                            String trianglesDataType = XMLUtil.getAttribute(trianglesChild, "DataType");
                            if (trianglesDataType.equals("float")) {
                                triangleSurface.setTrianglesDataType(XMLUtil.DataTypes.FLOAT);
                            } else if (trianglesDataType.equals("double")) {
                                triangleSurface.setTrianglesDataType(XMLUtil.DataTypes.DOUBLE);
                            } else if (trianglesDataType.equals("int") || trianglesDataType.equals("uint")) {
                                triangleSurface.setTrianglesDataType(XMLUtil.DataTypes.INT);
                            }
                            String trianglesEncodingType = XMLUtil.getAttribute(trianglesChild, "Encoding");
                            if (trianglesEncodingType.equals("ascii")) {
                                triangleSurface.setTrianglesEncodingType(XMLUtil.EncodingTypes.ASCII);
                            } else if (trianglesEncodingType.equals("base64")) {
                                triangleSurface.setTrianglesEncodingType(XMLUtil.EncodingTypes.BASE64);
                            }
                            triangleSurface.setTrianglesInflatedSize(Long.parseLong(XMLUtil.getAttribute(trianglesChild, "InflatedSize")));
                            triangleSurface.setTrianglesData(XMLUtil.decodeEncodedString(trianglesChild.getTextContent(), triangleSurface.getTrianglesDataType(), triangleSurface.getTrianglesEncodingType(), ByteOrder.LITTLE_ENDIAN));
                        }
                        continue;
                    }
                    if (!triangleSurfaceChild.getNodeName().equalsIgnoreCase("DIPOLEMAP")) continue;
                    triangleSurface.setNumberOfMaps(Integer.parseInt(XMLUtil.getAttribute(triangleSurfaceChild, "NumMaps")));
                    for (Node mapsChild = triangleSurfaceChild.getFirstChild(); mapsChild != null; mapsChild = mapsChild.getNextSibling()) {
                        if (!mapsChild.getNodeName().equalsIgnoreCase("DATA")) continue;
                        String mapsDataType = XMLUtil.getAttribute(mapsChild, "DataType");
                        if (mapsDataType.equals("float")) {
                            triangleSurface.setMapsDataType(XMLUtil.DataTypes.FLOAT);
                        } else if (mapsDataType.equals("double")) {
                            triangleSurface.setMapsDataType(XMLUtil.DataTypes.DOUBLE);
                        } else if (mapsDataType.equals("int") || mapsDataType.equals("uint")) {
                            triangleSurface.setMapsDataType(XMLUtil.DataTypes.INT);
                        }
                        String mapsEncodingType = XMLUtil.getAttribute(mapsChild, "Encoding");
                        if (mapsEncodingType.equals("ascii")) {
                            triangleSurface.setMapsEncodingType(XMLUtil.EncodingTypes.ASCII);
                        } else if (mapsEncodingType.equals("base64")) {
                            triangleSurface.setMapsEncodingType(XMLUtil.EncodingTypes.BASE64);
                        }
                        triangleSurface.setMapsInflatedSize(Long.parseLong(XMLUtil.getAttribute(mapsChild, "InflatedSize")));
                        triangleSurface.setMapsData(XMLUtil.decodeEncodedString(mapsChild.getTextContent(), triangleSurface.getMapsDataType(), triangleSurface.getMapsEncodingType(), ByteOrder.LITTLE_ENDIAN));
                    }
                }
                ArrayList<TriangleSurface> triangleSurfaces = geometryEGIG.getTriangleSurfaces();
                if (triangleSurfaces == null) {
                    triangleSurfaces = new ArrayList();
                    triangleSurfaces.add(triangleSurface);
                    geometryEGIG.setTriangleSurfaces(triangleSurfaces);
                    continue;
                }
                triangleSurfaces.add(triangleSurface);
            }
            return rVal;
        }
        if (!(toObject instanceof AnatomyEGIA)) return rVal;
        AnatomyEGIA anatomyEGIA = (AnatomyEGIA)toObject;
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        anatomyEGIA.setVolumes(volumes);
        Document document = XMLUtil.getDocumentFromURI(uri);
        if (document == null || (root = document.getDocumentElement()) == null) return rVal;
        root.normalize();
        if (!root.getNodeName().equalsIgnoreCase("EGIXML")) return rVal;
        for (Node egiXMLChild = root.getFirstChild(); egiXMLChild != null; egiXMLChild = egiXMLChild.getNextSibling()) {
            if (egiXMLChild.getNodeName().equalsIgnoreCase("HISTORY")) {
                ArrayList<String> history = new ArrayList<String>();
                for (Node historyChild = egiXMLChild.getFirstChild(); historyChild != null; historyChild = historyChild.getNextSibling()) {
                    if (!historyChild.getNodeName().equalsIgnoreCase("EVENT")) continue;
                    history.add(historyChild.getTextContent());
                }
                anatomyEGIA.setHistory(history);
                continue;
            }
            if (egiXMLChild.getNodeName().equalsIgnoreCase("SUBJECTINFO")) {
                SubjectInfo subjectInfo = new SubjectInfo();
                for (Node subjectInfoChild = egiXMLChild.getFirstChild(); subjectInfoChild != null; subjectInfoChild = subjectInfoChild.getNextSibling()) {
                    if (subjectInfoChild.getNodeName().equalsIgnoreCase("SUBJECTID")) {
                        subjectInfo.setSubjectID(subjectInfoChild.getTextContent());
                        continue;
                    }
                    if (subjectInfoChild.getNodeName().equalsIgnoreCase("MEDICALID")) {
                        subjectInfo.setMedicalID(subjectInfoChild.getTextContent());
                        continue;
                    }
                    if (subjectInfoChild.getNodeName().equalsIgnoreCase("FIRSTNAME")) {
                        subjectInfo.setFirstName(subjectInfoChild.getTextContent());
                        continue;
                    }
                    if (subjectInfoChild.getNodeName().equalsIgnoreCase("LASTNAME")) {
                        subjectInfo.setLastName(subjectInfoChild.getTextContent());
                        continue;
                    }
                    if (subjectInfoChild.getNodeName().equalsIgnoreCase("DOB")) {
                        subjectInfo.setDateOfBirth(subjectInfoChild.getTextContent());
                        continue;
                    }
                    if (!subjectInfoChild.getNodeName().equalsIgnoreCase("SEX")) continue;
                    subjectInfo.setGender(subjectInfoChild.getTextContent());
                }
                anatomyEGIA.setSubjectInfo(subjectInfo);
                continue;
            }
            if (!egiXMLChild.getNodeName().equalsIgnoreCase("VOLUME")) continue;
            Volume volume = new Volume();
            volume.setVoxelSize0(Float.parseFloat(XMLUtil.getAttribute(egiXMLChild, "VoxelSize0")));
            volume.setVoxelSize1(Float.parseFloat(XMLUtil.getAttribute(egiXMLChild, "VoxelSize1")));
            volume.setVoxelSize2(Float.parseFloat(XMLUtil.getAttribute(egiXMLChild, "VoxelSize2")));
            volume.setVoxelSpacing0(Float.parseFloat(XMLUtil.getAttribute(egiXMLChild, "VoxelSpacing0")));
            volume.setVoxelSpacing1(Float.parseFloat(XMLUtil.getAttribute(egiXMLChild, "VoxelSpacing1")));
            volume.setVoxelSpacing2(Float.parseFloat(XMLUtil.getAttribute(egiXMLChild, "VoxelSpacing2")));
            volume.setScanType(XMLUtil.getAttribute(egiXMLChild, "ScanType"));
            volume.setSource(XMLUtil.getAttribute(egiXMLChild, "Source"));
            for (Node volumeChild = egiXMLChild.getFirstChild(); volumeChild != null; volumeChild = volumeChild.getNextSibling()) {
                if (volumeChild.getNodeName().equalsIgnoreCase("DICOMDATA")) {
                    volume.setDICOMFile(XMLUtil.getAttribute(volumeChild, "DicomFile"));
                    continue;
                }
                if (volumeChild.getNodeName().equalsIgnoreCase("TRANSFORM")) continue;
                if (volumeChild.getNodeName().equalsIgnoreCase("DATA")) {
                    volume.setVolumeDimension0(Integer.parseInt(XMLUtil.getAttribute(volumeChild, "Dimension0")));
                    volume.setVolumeDimension1(Integer.parseInt(XMLUtil.getAttribute(volumeChild, "Dimension1")));
                    volume.setVolumeDimension2(Integer.parseInt(XMLUtil.getAttribute(volumeChild, "Dimension2")));
                    volume.setVolumeValuesPerVoxel(Integer.parseInt(XMLUtil.getAttribute(volumeChild, "ValuesPerVoxel")));
                    String volumeDataType = XMLUtil.getAttribute(volumeChild, "DataType");
                    if (volumeDataType.equals("float")) {
                        volume.setVolumeDataType(XMLUtil.DataTypes.FLOAT);
                    } else if (volumeDataType.equals("double")) {
                        volume.setVolumeDataType(XMLUtil.DataTypes.DOUBLE);
                    } else if (volumeDataType.equals("int") || volumeDataType.equals("uint")) {
                        volume.setVolumeDataType(XMLUtil.DataTypes.INT);
                    } else if (volumeDataType.equals("short") || volumeDataType.equals("ushort")) {
                        volume.setVolumeDataType(XMLUtil.DataTypes.SHORT);
                    }
                    String volumeEncodingType = XMLUtil.getAttribute(volumeChild, "Encoding");
                    if (volumeEncodingType.equals("ascii")) {
                        volume.setVolumeEncodingType(XMLUtil.EncodingTypes.ASCII);
                    } else if (volumeEncodingType.equals("base64")) {
                        volume.setVolumeEncodingType(XMLUtil.EncodingTypes.BASE64);
                    }
                    volume.setVolumeInflatedSize(Long.parseLong(XMLUtil.getAttribute(volumeChild, "InflatedSize")));
                    volume.setVolumeData(XMLUtil.decodeEncodedString(volumeChild.getTextContent(), volume.getVolumeDataType(), volume.getVolumeEncodingType(), ByteOrder.LITTLE_ENDIAN));
                    continue;
                }
                if (volumeChild.getNodeName().equalsIgnoreCase("SEGMENTATIONMAP")) {
                    for (Node segmentationMapChild = volumeChild.getFirstChild(); segmentationMapChild != null; segmentationMapChild = segmentationMapChild.getNextSibling()) {
                        ArrayList<Pair<String, String>> tissueTypes = new ArrayList<Pair<String, String>>();
                        if (!segmentationMapChild.getNodeName().equalsIgnoreCase("SEGMENTATIONMAP")) continue;
                        tissueTypes.add(new Pair<String, String>(XMLUtil.getAttribute(segmentationMapChild, "Name"), XMLUtil.getAttribute(segmentationMapChild, "Value")));
                    }
                    continue;
                }
                if (!volumeChild.getNodeName().equalsIgnoreCase("ACPOINT")) continue;
                float[] acPoints = new float[]{0.0f, 0.0f, 0.0f};
                acPoints[0] = Float.parseFloat(XMLUtil.getAttribute(volumeChild, "XCoord"));
                acPoints[0] = Float.parseFloat(XMLUtil.getAttribute(volumeChild, "YCoord"));
                acPoints[0] = Float.parseFloat(XMLUtil.getAttribute(volumeChild, "ZCoord"));
            }
            volumes.add(volume);
        }
        return rVal;
    }
}

