/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ChatPane;
import client.CommandHistory;
import client.PrivateMsg;
import client.ServerConnection;
import common.sd.SD_AdminAdd;
import common.sd.SD_Channel;
import common.sd.SD_Chat;
import common.sd.SD_Kick;
import common.sd.SD_Log;
import common.sd.SD_Private;
import common.sd.SD_Rename;
import common.sd.SD_UserAdd;
import common.sd.SD_UserDel;
import common.sd.SD_Whisper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class EEGLABChat
extends JPanel
implements ActionListener {
    public String username = null;
    public ServerConnection server;
    public int PORT;
    public String site;
    public ArrayList users;
    private CommandHistory history;
    public ArrayList ignores;
    public ArrayList afks;
    public ArrayList admins;
    public boolean admin;
    public String locationURL;
    public Hashtable channels;
    private static final String VERSION = "v0.8";
    public PrivateMsg privates;
    public boolean showUserStatus;
    public boolean chanAdmin;
    public boolean isNameParsed = false;
    public URL classLocation;
    public int m_nUsers;
    public JLabel m_lastMsg;
    private int m_textFontSize = 2;
    private double headlineHeightRatio = 0.1;
    private double textScrollerWidthRatio = 0.79;
    private double textScrollerHeightRatio = 0.69;
    private double messageAreaWidthRatio = 0.98;
    private double messageAreaHeightRatio = 0.15;
    private double heightBtwMsgTextScrollRatio = 0.06;
    private double bottomlineHeightRatio = 0.01;
    private double sideborderRatio = 0.01;
    private double userlistHeightRatio = 0.69;
    private double userlistWidthRatio = 0.19;
    Container c;
    ChatPane mainChat;
    JList userList;
    JTextField messageText;
    JTextArea messageArea;
    JScrollPane textScroller;
    JScrollPane userScroller;
    JPopupMenu popup;
    JButton helpMenuBtn;
    ImageIcon conNo;
    ImageIcon conYes;
    ImageIcon secNo;
    ImageIcon secYes;
    ImageIcon conSccn;
    ImageIcon conFontEnlarge;
    ImageIcon conFontReduce;
    JLabel conIcon;
    JLabel secIcon;
    JButton fontEnlargeIcon;
    JButton fontReduceIcon;
    JLabel sccnIcon;
    JLabel bottomText;
    JLabel topText;
    JLabel promptLabel;
    MyAction myAction;
    MyKeyListener myKeyListener;
    MyMouseListener myMouseListener;
    MyHyperlinkListener myHyperlinkListener;
    Color[] myColors = new Color[3];
    Rectangle rect;

    public void getClassLocation() {
        String cLocation = String.valueOf(EEGLABChat.class.getName().replace('.', '/')) + ".class";
        ClassLoader loader = EEGLABChat.class.getClassLoader();
        if (loader == null) {
            System.out.println("Cannot load the class");
        } else {
            this.classLocation = loader.getResource(cLocation);
        }
    }

    public void getClassLocationBase() {
        String cLocation = String.valueOf(EEGLABChat.class.getName().replace('.', '/')) + ".class";
        ClassLoader loader = EEGLABChat.class.getClassLoader();
        if (loader == null) {
            System.out.println("Cannot load the class");
        } else {
            this.classLocation = loader.getResource("images");
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int borderWidth = (int)((double)width * this.sideborderRatio);
        int borderHeight = (int)((double)height * this.sideborderRatio);
        int headlineHeight = (int)((double)height * this.headlineHeightRatio);
        int heightBtwMsgTextScroll = (int)((double)height * this.heightBtwMsgTextScrollRatio);
        this.textScroller.setBounds(borderWidth, headlineHeight, (int)((double)width * this.textScrollerWidthRatio), (int)((double)height * this.textScrollerHeightRatio));
        this.messageArea.setBounds(borderWidth, headlineHeight + this.textScroller.getHeight() + heightBtwMsgTextScroll, (int)((double)width * this.messageAreaWidthRatio), (int)((double)height * this.messageAreaHeightRatio));
        this.userScroller.setBounds(borderWidth + this.textScroller.getWidth(), headlineHeight, (int)((double)width * this.userlistWidthRatio), (int)((double)height * this.userlistHeightRatio));
        this.sccnIcon.setBounds(width / 2 - 90, (int)((double)height * this.headlineHeightRatio / 2.0) - 15, 30, 30);
        this.topText.setBounds(this.sccnIcon.getX() + 30, (int)((double)height * this.headlineHeightRatio / 2.0) - 15, 150, 30);
        this.promptLabel.setBounds(borderWidth, this.messageArea.getY() - 12, 200, 12);
        this.fontEnlargeIcon.setBounds(this.userScroller.getX(), this.userScroller.getY() + this.userScroller.getHeight(), 22, 22);
        this.fontReduceIcon.setBounds(this.userScroller.getX() + 22, this.userScroller.getY() + this.userScroller.getHeight(), 22, 22);
        this.helpMenuBtn.setBounds(this.userScroller.getX() + 44, this.userScroller.getY() + this.userScroller.getHeight(), 88, 22);
    }

    public void redraw() {
        this.show();
    }

    public String getGeoLocation(String ip) {
        try {
            String line;
            String data = String.valueOf(URLEncoder.encode("ip", "UTF-8")) + "=" + URLEncoder.encode(ip, "UTF-8");
            URL url = new URL("http://api.ipinfodb.com/v3/ip-city/?key=ce092ebcf84ba8905fc30c0c560856835022077f798a5e99ab4dcd05ecdc67f8");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String total = "";
            while ((line = rd.readLine()) != null) {
                total = String.valueOf(total) + line;
            }
            String[] tmpString = total.split(";");
            String cityName = tmpString[6];
            cityName = cityName.replace(' ', '_');
            wr.close();
            rd.close();
            return cityName;
        }
        catch (Exception e) {
            return "";
        }
    }

    public EEGLABChat(String ip) {
        this.site = ip;
    }

    public void init() {
        int width = this.getWidth();
        int height = this.getHeight();
        int borderWidth = (int)((double)width * this.sideborderRatio);
        int headlineHeight = (int)((double)height * this.headlineHeightRatio);
        int heightBtwMsgTextScroll = (int)((double)height * this.heightBtwMsgTextScrollRatio);
        this.getClassLocation();
        if (this.username == null) {
            try {
                InetAddress thisIp = InetAddress.getLocalHost();
                System.out.println(thisIp.getHostAddress());
                try {
                    this.username = this.readUsernameLog();
                }
                catch (Exception e) {
                    this.username = JOptionPane.showInputDialog(this, "Please enter a username", "Login", 3);
                    System.out.println("Username set to " + this.username);
                }
                if (this.username == null || this.username.equals("")) {
                    this.username = this.getGeoLocation(thisIp.getHostAddress());
                    System.out.println("Geo User Name " + this.username);
                    this.isNameParsed = false;
                } else {
                    this.isNameParsed = true;
                }
            }
            catch (Exception e) {
                this.username = "guest";
                e.printStackTrace();
            }
        }
        try {
            this.PORT = 42412;
        }
        catch (NumberFormatException e) {
            this.PORT = 42412;
        }
        this.locationURL = String.valueOf(this.site) + ":" + this.PORT + "/";
        System.out.println("Connection to " + this.locationURL);
        this.setSize(315, 365);
        this.c = this;
        this.c.setBackground(new Color(255, 255, 255));
        if (this.site == null || this.locationURL == null) {
            this.c.add(new JLabel("ERROR: did not recieve needed data from page"));
        }
        this.myAction = new MyAction();
        this.myKeyListener = new MyKeyListener();
        this.myMouseListener = new MyMouseListener();
        this.myHyperlinkListener = new MyHyperlinkListener();
        this.c.setLayout(null);
        this.mainChat = new ChatPane(this);
        this.textScroller = new JScrollPane(this.mainChat, 22, 31);
        this.textScroller.setBounds(borderWidth, headlineHeight, (int)((double)width * this.textScrollerWidthRatio), (int)((double)height * this.textScrollerHeightRatio));
        Font font = new Font("TimesRoman", 2, 50);
        this.mainChat.setFont(font);
        this.userList = new JList();
        this.userList.setSelectionMode(0);
        this.userList.setCellRenderer(new MyCellRenderer());
        this.userList.setBackground(new Color(249, 249, 250));
        this.userScroller = new JScrollPane(this.userList);
        this.userScroller.setBounds(borderWidth + this.textScroller.getWidth(), headlineHeight, (int)((double)width * this.userlistWidthRatio), (int)((double)height * this.userlistHeightRatio));
        this.messageText = new JTextField();
        this.messageText.setBounds(5, 319, 300, 22);
        this.messageText.setColumns(10);
        this.messageText.setBackground(new Color(249, 249, 250));
        this.messageText.setText("Message Text");
        this.messageArea = new JTextArea();
        this.messageArea.setBounds(borderWidth, headlineHeight + this.textScroller.getHeight() + heightBtwMsgTextScroll, (int)((double)width * this.messageAreaWidthRatio), (int)((double)height * this.messageAreaHeightRatio));
        this.messageArea.setColumns(10);
        this.messageArea.setRows(2);
        this.messageArea.setBackground(new Color(249, 249, 250));
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        this.messageArea.setBorder(loweredetched);
        this.popup = new JPopupMenu("test");
        this.popup.add("whisper").addActionListener(this.myAction);
        this.popup.add("private message").addActionListener(this.myAction);
        this.popup.add("ignore").addActionListener(this.myAction);
        this.popup.add("clear ignore list").addActionListener(this.myAction);
        this.conNo = new ImageIcon(this.getURL("images/connect_no.gif"));
        this.conYes = new ImageIcon(this.getURL("images/connect_established.gif"));
        this.secNo = new ImageIcon(this.getURL("images/decrypted.gif"));
        this.secYes = new ImageIcon(this.getURL("images/encrypted.gif"));
        this.conSccn = new ImageIcon(this.getURL("images/SCCN.gif"));
        this.conFontEnlarge = new ImageIcon(this.getURL("images/MagnifyPlus.gif"));
        this.conFontReduce = new ImageIcon(this.getURL("images/MagnifyMinus.gif"));
        try {
            this.conIcon = new JLabel(this.conNo);
            this.conIcon.setBorder(new EtchedBorder());
            this.secIcon = new JLabel(this.secNo);
            this.secIcon.setBorder(new EtchedBorder());
            this.sccnIcon = new JLabel(this.conSccn);
            this.sccnIcon.setBorder(new EtchedBorder());
            this.fontEnlargeIcon = new JButton(this.conFontEnlarge);
            this.fontReduceIcon = new JButton(this.conFontReduce);
            this.helpMenuBtn = new JButton("help");
            this.fontEnlargeIcon.addActionListener(this);
            this.fontEnlargeIcon.setActionCommand("Enlarge");
            this.fontReduceIcon.addActionListener(this);
            this.fontReduceIcon.setActionCommand("Reduce");
            this.helpMenuBtn.addActionListener(this.myAction);
            this.helpMenuBtn.setActionCommand("help");
            this.conIcon.setBounds(563, 334, 22, 22);
            this.secIcon.setBounds(588, 334, 22, 22);
            this.sccnIcon.setBounds(width / 2 - 90, (int)((double)height * this.headlineHeightRatio / 2.0) - 15, 30, 30);
            this.fontEnlargeIcon.setBounds(this.userScroller.getX(), this.userScroller.getY() + this.userScroller.getHeight(), 22, 22);
            this.fontReduceIcon.setBounds(this.userScroller.getX() + 22, this.userScroller.getY() + this.userScroller.getHeight(), 22, 22);
            this.helpMenuBtn.setBounds(this.userScroller.getX() + 44, this.userScroller.getY() + this.userScroller.getHeight(), 88, 22);
            this.topText = new JLabel("<html><body><font color=#445577><b>EEGLAB Chat</b></font> &nbsp; <a href=\"http://sccn.ucsd.edu/eeglab/\"></a></body></html>");
            this.topText.setBounds(this.sccnIcon.getX() + 30, (int)((double)height * this.headlineHeightRatio / 2.0) - 15, 150, 30);
            this.bottomText = new JLabel("<html><body><font color=#FF0000 size=2><b>online users</b></font></body></html>");
            this.bottomText.setBounds(220, 365, 100, 20);
            this.promptLabel = new JLabel("<html><body><font color=#445588 size=1><b>Type here:</b></font></body></html>");
            this.promptLabel.setBounds(borderWidth, this.messageArea.getY() - 12, 200, 12);
            this.c.add(this.textScroller);
            this.c.add(this.userScroller);
            this.c.add(this.messageArea);
            this.c.add(this.topText);
            this.c.add(this.promptLabel);
            this.c.add(this.sccnIcon);
            this.c.add(this.fontEnlargeIcon);
            this.c.add(this.fontReduceIcon);
            this.c.add(this.helpMenuBtn);
            this.userList.addMouseListener(this.myMouseListener);
            this.messageArea.addKeyListener(this.myKeyListener);
            this.messageText.addKeyListener(this.myKeyListener);
            this.bottomText.addMouseListener(this.myMouseListener);
            this.m_lastMsg = new JLabel();
            this.users = new ArrayList();
            this.ignores = new ArrayList(5);
            this.ignores.add("server");
            this.afks = new ArrayList(5);
            this.admins = new ArrayList(5);
            this.history = new CommandHistory(10);
            this.admin = false;
            this.channels = new Hashtable();
            this.privates = new PrivateMsg(this, this.m_textFontSize);
            this.showUserStatus = false;
            this.myColors[0] = new Color(200, 0, 0);
            this.myColors[1] = new Color(0, 150, 0);
            this.myColors[2] = new Color(0, 0, 200);
            this.rect = new Rectangle(0, 0, 1, 1);
            if (!this.username.matches("[\\w_-]+?")) {
                this.error("username contains invalid characters, changing to 'invalid' for now. Type \\rename to chose a new name");
                this.username = "invalid";
            }
            if (this.username.length() > 10) {
                this.username = this.username.substring(0, 10);
                this.error("username too long, changed to " + this.username);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.connect();
        String opening = "<font color=#333333>==================================<br>Welcome to EEGLAB Chat Room<br>If you need assistance, type \\help<br>Enjoy your stay!<br>==================================<br></font>";
        HTMLDocument doc = (HTMLDocument)this.mainChat.getDocument();
        HTMLEditorKit kit = (HTMLEditorKit)this.mainChat.getEditorKit();
        try {
            kit.insertHTML(doc, doc.getLength(), opening, 0, 0, HTML.Tag.FONT);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    public void writeUsernameLog(String username) {
        try {
            String userDir = System.getProperty("user.home");
            FileWriter fstream = new FileWriter(String.valueOf(userDir) + "/EEGLabRoomLog");
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(username);
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public String readUsernameLog() {
        String username = null;
        try {
            String userDir = System.getProperty("user.home");
            File log = new File(String.valueOf(userDir) + "/EEGLabRoomLog");
            if (log.exists()) {
                FileReader fstream = new FileReader(String.valueOf(userDir) + "/EEGLabRoomLog");
                BufferedReader in = new BufferedReader(fstream);
                username = in.readLine();
                in.close();
                fstream.close();
            }
        }
        catch (Exception e) {
            System.out.println("Warning: Could find username..." + e.getMessage());
        }
        return username;
    }

    public void start() {
    }

    public void stop() throws IOException {
        if (this.server != null) {
            this.server._writeObject(new SD_UserDel(null));
        }
    }

    protected final URL getURL(String filename) {
        URL url = null;
        String executionPath = System.getProperty("user.dir");
        url = this.getClass().getResource("/images");
        System.out.println("getting " + filename);
        url = this.getClass().getResource("/" + filename);
        return url;
    }

    private void sendMessage() throws IOException {
        String txt = new String(this.messageArea.getText());
        if (!txt.equals("")) {
            if (txt.charAt(0) == '\\' || txt.charAt(0) == '/') {
                this.parseCommand(txt.substring(1));
                this.messageArea.setText("");
                this.history.add(txt);
            } else if (this.server != null && this.server.connected && this.username != null) {
                this.sendText(this.username, txt, false);
                this.messageArea.setText("");
                this.sendChat(txt);
                this.history.add(txt);
            } else {
                this.error("Not connected, type \\reconnect to try and reconnect");
            }
        }
        this.messageArea.setCaretPosition(0);
    }

    public boolean parseCommand(String cmd) throws IOException {
        cmd = cmd.intern();
        if ((cmd = cmd.replaceAll("\n", "")) == "help" || cmd == "?") {
            String commands = "Listing  available commands:\n<pre>\\help or \\? \t\t- display this message<br>\\admin &lt;passphrase&gt; \t- become an admin<br>\\create &lt;channel&gt; [password]\t- create a new channel with optional password<br>\\join &lt;channel&gt;  [password]\t- join channel with optional password<br>\\disconnect \t\t- disconnect from server<br>\\whisper &lt;user&gt; &lt;message&gt; \t- whisper to a user<br>\\private &lt;user&gt; \t- start a private message session<br>\\ignore &lt;user&gt; \t\t- ignores a user<br>\\clearignore \t\t- clear list of ignores<br>\\reconnect \t\t- attempt to reconnect to server<br>\\rename &lt;new name&gt; \t\t- change your username<br>";
            if (this.admin) {
                commands = String.valueOf(commands) + "\\kick &lt;user&gt; \t\t- kick user from room<br>\\logstart \t\t- start logging sessoin<br>\\logstop \t\t- stop logging session<br>";
            }
            commands = String.valueOf(commands) + "up or down \t\t- cycle your chat history</pre>";
            this.sendText("server", commands, false);
            return true;
        }
        if (cmd == "disconnect") {
            if (this.server != null) {
                this.stop();
            }
            return true;
        }
        if (cmd.equals("reconnect")) {
            if (this.username == null) {
                this.error("username still invalid. use \\rename &lt;new name&gt; to chose a new name and reconnect");
            } else {
                if (this.server != null) {
                    this.stop();
                }
                this.server = new ServerConnection(this);
            }
            return true;
        }
        if (cmd == "clearignore") {
            this.ignores.clear();
            this.updateList();
            this.serverMessage("ignore list cleared");
            return true;
        }
        if (cmd.startsWith("whisper")) {
            int start = cmd.indexOf(32);
            if (start < 0) {
                this.error("usage: \\whisper &lt;user&gt; &lt;message&gt;");
                return false;
            }
            if ((start = (cmd = cmd.substring(start + 1)).indexOf(32)) < 0) {
                this.error("usage: \\whisper &lt;user&gt; &lt;message&gt;");
                return false;
            }
            String un = cmd.substring(0, start);
            if (this.username.equals(un) || !this.users.contains(un)) {
                this.error("invalid user");
                return false;
            }
            String message = cmd.substring(start + 1);
            if (message.length() < 1) {
                this.error("usage: \\whisper &lt;user&gt; &lt;message&gt;");
            }
            this.sendWhisper(un, message);
            this.sendText(this.username, message, true);
            return true;
        }
        if (cmd.startsWith("private")) {
            int start = cmd.indexOf(32);
            if (start < 0) {
                this.error("usage: \\private &lt;user&gt;");
                return false;
            }
            String un = cmd.substring(start + 1);
            if (this.username.equals(un)) {
                this.error("cannot private message yourself");
                return false;
            }
            this.privates.newPrivate(un);
            return true;
        }
        if (cmd.startsWith("rename")) {
            int start = cmd.indexOf(32);
            if (start < 0) {
                this.error("usage: \\rename &lt;newname&gt;");
                return false;
            }
            String newName = cmd.substring(start + 1);
            if (newName.length() < 1 || newName.length() > 10 || newName.equals("server") || !newName.matches("[\\w_-]+?")) {
                this.error("invalid name");
                return false;
            }
            if (!this.server.connected) {
                this.server = new ServerConnection(this);
            }
            if (this.username == null) {
                this.username = newName;
                this.server.writeObject(new SD_UserAdd(newName, false));
            } else {
                this.rename(this.username, newName);
                String on = this.username;
                this.username = newName;
                this.server.writeObject(new SD_Rename(on, this.username));
            }
            return true;
        }
        if (cmd.startsWith("ignore")) {
            int start = cmd.indexOf(32);
            if (start < 0) {
                this.error("usage: \\ignre &lt;user&gt;");
                return false;
            }
            this.ignore(cmd.substring(start + 1), false);
            return true;
        }
        if (cmd.startsWith("join")) {
            int start = cmd.indexOf(32);
            if (start < 0) {
                this.error("usage: \\join &lt;channel&gt; [password]");
                return false;
            }
            String name = cmd.substring(start + 1);
            String pass = null;
            start = name.indexOf(32);
            if (start > 0) {
                pass = name.substring(start + 1);
                name = name.substring(0, start);
            }
            this.server.writeObject(new SD_Channel(false, name, pass));
            return true;
        }
        if (cmd.startsWith("create")) {
            int start = cmd.indexOf(32);
            if (start < 0) {
                this.error("usage: \\create &lt;channel&gt; [password]");
                return false;
            }
            String name = cmd.substring(start + 1);
            String pass = null;
            start = name.indexOf(32);
            if (start > 0) {
                pass = name.substring(start + 1);
                name = name.substring(0, start);
            }
            this.server.writeObject(new SD_Channel(true, name, pass));
            return true;
        }
        if (cmd.startsWith("admin")) {
            int start = cmd.indexOf(32);
            if (start < 0) {
                this.error("usage: \\admin &lt;password&gt;");
                return false;
            }
            String pass = cmd.substring(start + 1);
            this.server.writeObject(new SD_AdminAdd(pass));
            return true;
        }
        if (this.admin && cmd.startsWith("kick")) {
            int start = cmd.indexOf(32);
            if (start < 0) {
                this.error("usage: \\kick &lt;user&gt;");
                return false;
            }
            String un = cmd.substring(start + 1);
            if (un.equals(this.username)) {
                this.error("cannot kick yourself");
                return false;
            }
            this.server.writeObject(new SD_Kick(un));
            return true;
        }
        if (this.admin && cmd == "logstart") {
            this.server.writeObject(new SD_Log(true));
            return true;
        }
        if (this.admin && cmd == "logstop") {
            this.server.writeObject(new SD_Log());
            return true;
        }
        this.error("unrecognized command, type \\help for help");
        return false;
    }

    private boolean ignore(String i, boolean quiet) {
        if (this.username.equals(i) || i.equals("server") || this.admins.contains(i)) {
            if (!quiet) {
                this.error("can't ignore that person");
            }
            return false;
        }
        if (!this.users.contains(i)) {
            if (!quiet) {
                this.error("user does not exists");
            }
            return false;
        }
        if (this.ignores.contains(i)) {
            if (!quiet) {
                this.error("already ignoring user");
            }
            return false;
        }
        this.ignores.add(i);
        this.updateList();
        if (!quiet) {
            this.serverMessage("ignoring " + i);
        }
        return true;
    }

    public void sendText(String un, String message, boolean whisper) {
        this.mainChat.sendText(un, message, whisper, this.m_textFontSize);
        this.m_lastMsg.setText(String.valueOf(un) + " said " + "'" + message + "'");
    }

    private ServerConnection connect() {
        this.server = new ServerConnection(this);
        return this.server;
    }

    private void sendChat(String message) {
        if (this.server != null) {
            this.server.writeObject(new SD_Chat(null, message));
            this.m_lastMsg.setText("you said '" + message + "'");
        }
    }

    private void sendWhisper(String to, String message) {
        if (this.server != null) {
            this.server.writeObject(new SD_Whisper(to, message));
        }
    }

    public void updateUserNumber(int nUsers) {
        this.m_nUsers = nUsers;
        if (this.m_nUsers == 1) {
            this.bottomText.setText("<html><body><font color=#FF0000 size=2><b>" + this.m_nUsers + " online user" + "</b></font>" + "</body></html>");
        } else {
            this.bottomText.setText("<html><body><font color=#FF0000 size=2><b>" + this.m_nUsers + " online users" + "</b></font>" + "</body></html>");
        }
    }

    public int getUserNumber() {
        return this.m_nUsers;
    }

    public String getLastMsg() {
        return this.m_lastMsg.getText();
    }

    public void updateList() {
        Object[] tmp = this.users.toArray();
        Arrays.sort(tmp);
        this.userList.setListData(tmp);
    }

    public void userAdd(String un, boolean isParsed) {
        if (!this.users.contains(un)) {
            this.users.add(un);
            this.updateList();
            if (!un.equals(this.username) && this.showUserStatus) {
                this.serverMessage(String.valueOf(un) + " has joined us.");
            }
        }
    }

    public void userDel(String un) {
        this.users.remove(this.users.indexOf(un));
        if (this.ignores.contains(un)) {
            this.ignores.remove(this.ignores.indexOf(un));
        }
        if (this.afks.contains(un)) {
            this.afks.remove(this.afks.indexOf(un));
        }
        if (this.admins.contains(un)) {
            this.admins.remove(this.admins.indexOf(un));
        }
        this.updateList();
        this.serverMessage(String.valueOf(un) + " has left.");
        this.privates.serverMessage(un, String.valueOf(un) + " has left");
    }

    public void rename(String on, String nn) {
        if (this.admins.contains(on)) {
            this.admins.remove(this.admins.indexOf(on));
            this.admins.add(nn);
        }
        if (this.afks.contains(on)) {
            this.afks.remove(this.afks.indexOf(on));
            this.afks.add(nn);
        }
        if (this.ignores.contains(on)) {
            this.ignores.remove(this.ignores.indexOf(on));
            this.ignores.add(nn);
        }
        this.users.remove(on);
        this.users.add(nn);
        this.updateList();
    }

    public void recieveChat(String un, String message) {
        if (!this.ignores.contains(un)) {
            this.sendText(un, message, false);
            this.m_lastMsg.setText(String.valueOf(un) + " said " + "'" + message + "'");
        }
    }

    public void recieveWhisper(String un, String message) {
        if (!this.ignores.contains(un)) {
            this.sendText(un, message, true);
            this.m_lastMsg.setText(String.valueOf(un) + " said " + "'" + message + "'");
        }
    }

    public void recievePrivate(String un, String message) {
        if (!this.ignores.contains(un)) {
            this.privates.recievePrivate(un, message, this.m_textFontSize);
        }
    }

    public void error(String s) {
        this.mainChat.error(s);
    }

    public void serverMessage(String s) {
    }

    public void close() throws IOException {
        this.error("Connection to server was lost");
        this.writeUsernameLog(this.username);
        this.userDel(this.username);
        this.admin = false;
        this.users.clear();
        this.afks.clear();
        this.ignores.clear();
        this.admins.clear();
        this.channels.clear();
        this.stop();
        this.server.close();
        this.updateList();
    }

    public void setConnected(boolean b) {
        if (b) {
            this.conIcon.setIcon(this.conYes);
            this.conIcon.setToolTipText("Connected");
            this.secIcon.setIcon(this.secYes);
            this.secIcon.setToolTipText("Secure Connection");
        } else {
            this.conIcon.setIcon(this.conNo);
            this.conIcon.setToolTipText("Not Connected");
            this.secIcon.setIcon(this.secNo);
            this.secIcon.setToolTipText("Connection not Secured");
        }
    }

    public void setAdmin() {
        this.admin = true;
        this.popup.add("kick user").addActionListener(this.myAction);
    }

    public void newChannel(String name, boolean pass) {
        if (this.channels.containsKey(name)) {
            this.channels.remove(name);
        } else {
            this.channels.put(name, new Boolean(pass));
        }
    }

    public void sendPrivate(String name, String message) {
        this.server.writeObject(new SD_Private(name, String.valueOf(message) + "\n"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Enlarge") {
            if (this.m_textFontSize < 5) {
                ++this.m_textFontSize;
            }
        } else if (this.m_textFontSize > 1) {
            --this.m_textFontSize;
        }
        this.mainChat.changeFontSize(this.m_textFontSize);
    }

    public ChatPane GetPane() {
        return this.mainChat;
    }

    public JTextArea GetMessageArea() {
        return this.messageArea;
    }

    public JTextField GetMessageText() {
        return this.messageText;
    }

    public JList GetUsers() {
        return this.userList;
    }

    public JTextArea GetLastMsgArea() {
        return new JTextArea(this.getLastMsg());
    }

    public JPanel GetFigPanel(JComponent one, JComponent two, JComponent three) {
        GridLayout gLay = new GridLayout(3, 1);
        JPanel j = new JPanel(gLay);
        j.add(one);
        j.add(two);
        j.add(three);
        return j;
    }

    public void UpdatePanel(JPanel j) {
        j.add((Component)this.GetMessageArea(), 1);
        j.add((Component)this.GetMessageText(), 2);
        j.add((Component)this.GetUsers(), 3);
    }

    public String GetHistory() {
        return this.history.toString();
    }

    @Override
    public void show() {
        super.setVisible(true);
    }

    @Override
    public void hide() {
        super.setVisible(false);
    }

    public EEGLABChat GetInstance() {
        return this;
    }

    protected final class MyAction
    implements ActionListener {
        protected MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand().intern();
            if (cmd == "whisper") {
                String user = (String)EEGLABChat.this.userList.getSelectedValue();
                if (user != null && !EEGLABChat.this.messageArea.getText().equals("") && !user.equals(EEGLABChat.this.username)) {
                    EEGLABChat.this.messageArea.setText("\\whisper " + user + " " + EEGLABChat.this.messageArea.getText());
                    try {
                        EEGLABChat.this.sendMessage();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    EEGLABChat.this.error("invalid user or no message, type a message below, select a user, and then whisper");
                }
            } else if (cmd == "private message") {
                String user = (String)EEGLABChat.this.userList.getSelectedValue();
                if (user != null && !user.equals(EEGLABChat.this.username)) {
                    EEGLABChat.this.privates.newPrivate(user);
                } else {
                    EEGLABChat.this.error("invalid user");
                }
            } else if (ae.getActionCommand().equals("ignore")) {
                String user = (String)EEGLABChat.this.userList.getSelectedValue();
                if (user != null) {
                    EEGLABChat.this.ignore(user, false);
                } else {
                    EEGLABChat.this.error("no user selected");
                }
            } else if (cmd == "clear ignore list") {
                EEGLABChat.this.ignores.clear();
                EEGLABChat.this.updateList();
                EEGLABChat.this.serverMessage("ignore list cleared");
            } else if (cmd == "kick user") {
                String user = (String)EEGLABChat.this.userList.getSelectedValue();
                if (user != null) {
                    if (user.equals(EEGLABChat.this.username)) {
                        EEGLABChat.this.error("cannot kick yourself");
                    } else {
                        EEGLABChat.this.server.writeObject(new SD_Kick(user));
                    }
                } else {
                    EEGLABChat.this.error("no user selected");
                }
            } else if (cmd == "help") {
                JOptionPane.showMessageDialog(EEGLABChat.this.c, "Listing  available commands:\n\\help or \\? \t\t- display this message\n\\admin <passphrase> \t- become an admin\n\\create <channel> [password]\t- create a new channel with optional password\n\\join <channel>  [password]\t- join channel with optional password\n\\disconnect \t\t- disconnect from server\n\\whisper <user> <message> \t- whisper to a user\n\\private <user> \t- start a private message session\n\\ignore <user> \t\t- ignores a user\n\\clearignore \t\t- clear list of ignores\n\\reconnect \t\t- attempt to reconnect to server\n\\rename <new name> \t\t- change your username\n", "EEGLab Chat Help", -1);
            }
        }
    }

    protected final class MyCellRenderer
    extends DefaultListCellRenderer {
        final ImageIcon normal;
        final ImageIcon ignored;
        final ImageIcon afk;
        final ImageIcon admin;

        protected MyCellRenderer() {
            this.normal = new ImageIcon(EEGLABChat.this.getURL("images/face.gif"));
            this.ignored = new ImageIcon(EEGLABChat.this.getURL("images/face_ignore.gif"));
            this.afk = new ImageIcon(EEGLABChat.this.getURL("images/afk.gif"));
            this.admin = new ImageIcon(EEGLABChat.this.getURL("images/admin.gif"));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
            super.getListCellRendererComponent((JList<?>)list, value, index, iss, chf);
            if (EEGLABChat.this.afks.contains(value.toString())) {
                this.setIcon(this.afk);
            } else if (EEGLABChat.this.admins.contains(value.toString())) {
                this.setIcon(this.admin);
            } else if (EEGLABChat.this.ignores.contains(value.toString())) {
                this.setIcon(this.ignored);
            } else {
                this.setIcon(this.normal);
            }
            if (EEGLABChat.this.username.equals(this.getText())) {
                this.setForeground(EEGLABChat.this.myColors[1]);
            } else {
                this.setForeground(EEGLABChat.this.myColors[2]);
            }
            return this;
        }
    }

    protected final class MyHyperlinkListener
    implements HyperlinkListener {
        protected MyHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
        }
    }

    protected final class MyKeyListener
    implements KeyListener {
        protected MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent ke) {
            if (ke.getKeyChar() == '\n') {
                try {
                    EEGLABChat.this.sendMessage();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            String down;
            if (ke.getKeyCode() == 38) {
                String up = EEGLABChat.this.history.getUp();
                if (up != null) {
                    EEGLABChat.this.messageArea.setText(up);
                }
            } else if (ke.getKeyCode() == 40 && (down = EEGLABChat.this.history.getDown()) != null) {
                EEGLABChat.this.messageArea.setText(down);
            }
        }
    }

    protected final class MyMouseListener
    implements MouseListener {
        protected MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getSource() == EEGLABChat.this.bottomText) {
                EEGLABChat.this.bottomText.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getSource() == EEGLABChat.this.bottomText) {
                EEGLABChat.this.bottomText.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void maybeShowPopup(MouseEvent e) {
            if ((e.getModifiers() & 4) != 0) {
                EEGLABChat.this.popup.show(EEGLABChat.this.userList, e.getX(), e.getY());
            }
        }
    }
}

