/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ChatPane;
import client.EEGLABChat;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PrivateMsg {
    EEGLABChat llamaChat;
    private Hashtable privates;
    int m_textFontSize;

    PrivateMsg(EEGLABChat lc, int fontSize) {
        this.llamaChat = lc;
        this.privates = new Hashtable();
        this.m_textFontSize = fontSize;
    }

    public void recievePrivate(String username, String message, int size) {
        MsgWindow msg = this.newPrivate(username);
        if (msg != null) {
            msg.cp.sendText(username, message, size);
        }
    }

    public MsgWindow newPrivate(String username) {
        if (!this.llamaChat.users.contains(username)) {
            this.llamaChat.error(String.valueOf(username) + " does not exist");
            return null;
        }
        if (this.llamaChat.ignores.contains(username)) {
            this.llamaChat.error(String.valueOf(username) + " is ignored, cannot private message");
            return null;
        }
        MsgWindow msg = null;
        if (this.privates.containsKey(username)) {
            msg = (MsgWindow)this.privates.get(username);
        } else {
            msg = new MsgWindow(username, this.m_textFontSize);
            this.privates.put(username, msg);
        }
        return msg;
    }

    public void serverMessage(String username, String message) {
        if (this.privates.containsKey(username)) {
            MsgWindow msg = (MsgWindow)this.privates.get(username);
            msg.cp.sendText("server", message, this.m_textFontSize);
        }
    }

    private class MsgWindow
    extends JFrame {
        ChatPane cp;
        JTextField messageText;
        String username;
        int m_textFontSize;

        MsgWindow(String un, int fontSize) {
            super("Private Message: " + un);
            this.m_textFontSize = fontSize;
            this.username = un;
            this.setSize(new Dimension(350, 200));
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    MsgWindow cur = (MsgWindow)e.getWindow();
                    Enumeration _enum = PrivateMsg.this.privates.keys();
                    while (_enum.hasMoreElements()) {
                        String user = (String)_enum.nextElement();
                        MsgWindow tmpFra = (MsgWindow)PrivateMsg.this.privates.get(user);
                        if (!cur.equals(tmpFra)) continue;
                        PrivateMsg.this.privates.remove(user);
                        break;
                    }
                }
            });
            this.cp = new ChatPane(PrivateMsg.this.llamaChat);
            this.messageText = new JTextField();
            this.messageText.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent ke) {
                    String txt;
                    if (ke.getKeyChar() == '\n' && !(txt = new String(MsgWindow.this.messageText.getText())).equals("")) {
                        if (!((MsgWindow)MsgWindow.this).PrivateMsg.this.llamaChat.users.contains(MsgWindow.this.username)) {
                            MsgWindow.this.cp.error(String.valueOf(MsgWindow.this.username) + " does not exist");
                        } else {
                            ((MsgWindow)MsgWindow.this).PrivateMsg.this.llamaChat.sendPrivate(MsgWindow.this.username, txt);
                            MsgWindow.this.cp.sendText(((MsgWindow)MsgWindow.this).PrivateMsg.this.llamaChat.username, txt, MsgWindow.this.m_textFontSize);
                        }
                        MsgWindow.this.messageText.setText("");
                    }
                }

                @Override
                public void keyPressed(KeyEvent ke) {
                }

                @Override
                public void keyReleased(KeyEvent ke) {
                }
            });
            this.getContentPane().add((Component)new JScrollPane(this.cp, 22, 31), "Center");
            this.getContentPane().add((Component)this.messageText, "South");
            this.setVisible(true);
            this.cp.sendText("server", "Private message session started with " + un, this.m_textFontSize);
        }
    }
}

