/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import server.ClientConnection;

public final class ChannelManager {
    public static char allowUserChannels;
    public String defaultChannel;
    private int defaultCount;
    private static Hashtable systemChannels;
    private static Hashtable userChannels;
    public static final String eName = "Invalid Channel Name";
    public static final String eAllowed = "User Channels not allowed";
    public static final String eAdmin = "Admin only operation";

    ChannelManager() {
        allowUserChannels = (char)121;
        this.defaultChannel = "Lobby";
        this.defaultCount = 0;
        systemChannels = null;
        userChannels = null;
    }

    public boolean setDefaultChannel(String name) {
        if (!name.equals(this.defaultChannel) && !this.isValidChannel(name)) {
            return false;
        }
        this.defaultChannel = name;
        return true;
    }

    public boolean addSystemChannel(String name, String pass) {
        if (!this.isValidChannel(name)) {
            return false;
        }
        if (systemChannels == null) {
            systemChannels = new Hashtable();
        }
        systemChannels.put(name, new ChannelManagerItem(pass));
        return true;
    }

    public String addUserChannel(String name, String pass, ClientConnection cc) {
        if (allowUserChannels == 'n') {
            return eAllowed;
        }
        if (allowUserChannels == 'a' && !cc.isAdmin()) {
            return eAdmin;
        }
        if (!this.isValidChannel(name)) {
            return eName;
        }
        if (userChannels == null) {
            userChannels = new Hashtable();
        }
        userChannels.put(name, new ChannelManagerItem(pass));
        return null;
    }

    public boolean userAdd(String name, String pass) {
        if (this.defaultChannel.equals(name)) {
            ++this.defaultCount;
            return true;
        }
        if (systemChannels != null && systemChannels.containsKey(name)) {
            ChannelManagerItem value = (ChannelManagerItem)systemChannels.get(name);
            if (value == null) {
                return false;
            }
            if (value.pass == null || value.pass.equals(pass)) {
                value.countpp();
                return true;
            }
            return false;
        }
        if (userChannels != null && userChannels.containsKey(name)) {
            ChannelManagerItem value = (ChannelManagerItem)userChannels.get(name);
            if (value == null) {
                return false;
            }
            if (value.pass == null || value.pass.equals(pass)) {
                value.countpp();
                return true;
            }
        }
        return false;
    }

    public boolean userDel(String name) {
        if (this.defaultChannel.equals(name)) {
            --this.defaultCount;
            return false;
        }
        if (systemChannels != null && systemChannels.containsKey(name)) {
            ChannelManagerItem value = (ChannelManagerItem)systemChannels.get(name);
            if (value != null) {
                value.countmm();
            }
            return false;
        }
        if (userChannels != null && userChannels.containsKey(name)) {
            ChannelManagerItem value = (ChannelManagerItem)userChannels.get(name);
            if (value == null) {
                return false;
            }
            if (value.countmm()) {
                userChannels.remove(name);
                return true;
            }
        }
        return false;
    }

    public boolean isValidChannel(String name) {
        return !(this.defaultChannel.equals(name) || systemChannels != null && systemChannels.containsKey(name) || userChannels != null && userChannels.containsKey(name) || name.length() > 12) && name.matches("[\\w_-]+?");
    }

    public boolean channelExists(String name) {
        return this.defaultChannel.equals(name) || systemChannels != null && systemChannels.containsKey(name) || userChannels != null && userChannels.containsKey(name);
    }

    public String channelHasPass(String name) {
        if (this.defaultChannel.equals(name)) {
            return null;
        }
        if (systemChannels != null && systemChannels.containsKey(name)) {
            ChannelManagerItem value = (ChannelManagerItem)systemChannels.get(name);
            if (value != null && value.pass != null) {
                return "";
            }
            return null;
        }
        if (userChannels != null && userChannels.containsKey(name)) {
            ChannelManagerItem value = (ChannelManagerItem)userChannels.get(name);
            if (value != null && value.pass != null) {
                return "";
            }
            return null;
        }
        return null;
    }

    public Enumeration enumerate() {
        Enumeration e;
        Vector<String> all = new Vector<String>();
        all.add(this.defaultChannel);
        if (systemChannels != null) {
            e = systemChannels.keys();
            while (e.hasMoreElements()) {
                all.add((String)e.nextElement());
            }
        }
        if (userChannels != null) {
            e = userChannels.keys();
            while (e.hasMoreElements()) {
                all.add((String)e.nextElement());
            }
        }
        return all.elements();
    }

    public class ChannelManagerItem {
        public int count = 0;
        public String pass;

        ChannelManagerItem() {
            this.pass = null;
        }

        ChannelManagerItem(String p) {
            this.pass = p == null ? null : new String(p);
        }

        public void countpp() {
            ++this.count;
        }

        public boolean countmm() {
            --this.count;
            return this.count == 0;
        }
    }
}

