/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.sd.SD_AdminAdd;
import common.sd.SD_Channel;
import common.sd.SD_Chat;
import common.sd.SD_Error;
import common.sd.SD_ServerCap;
import common.sd.SD_UpdateUserNumber;
import common.sd.SD_UserAdd;
import common.sd.SD_UserDel;
import common.sd.SocketData;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Queue;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import server.ChannelManager;
import server.ClientConnection;
import server.ConfigParser;

public final class EEGLABChatServer
extends Thread {
    private static EEGLABChatServer listeningServer;
    public static int PORT;
    public static String sysLogFile;
    public static String adminPass;
    public static LinkedList connectingUsers;
    public static Hashtable connectedUsers;
    public static boolean running;
    public static boolean allowAdmin;
    private static PrintWriter sysLogOut;
    public static String chatLogPath;
    private static Hashtable channelFiles;
    public static String userExportFile;
    public static ChannelManager channels;
    public static String welcomeMessage;
    public static String serverConfigFile;
    public int m_nUsers = 0;
    public String m_serverIP = "";
    private JTextComponent text;
    private JEditorPane pane;
    private static Queue<Object> lobbyMessages;
    static final int maxLobbyMessages = 100;
    private static LinkedList usernameDatabase;

    static {
        PORT = 42412;
        sysLogFile = "EEGLABChat.log";
        adminPass = "EEGLABChat";
        allowAdmin = true;
        chatLogPath = ".";
        userExportFile = null;
        welcomeMessage = null;
        serverConfigFile = "EEGLABchatconf.xml";
    }

    public String generateUsername(String usernameBase) {
        NameNumPair pair;
        String username = "";
        if (usernameDatabase == null) {
            usernameDatabase = new LinkedList();
        }
        ListIterator iterator = usernameDatabase.listIterator();
        while (iterator.hasNext()) {
            pair = (NameNumPair)iterator.next();
            if (pair.name.compareTo(usernameBase) != 0) continue;
            ++pair.number;
            username = String.valueOf(pair.name) + Integer.toString(pair.number);
            return username;
        }
        pair = new NameNumPair();
        pair.number = 0;
        pair.name = usernameBase;
        usernameDatabase.add(pair);
        username = String.valueOf(pair.name) + Integer.toString(pair.number);
        return username;
    }

    public synchronized void newUser(SSLSocket s) throws InterruptedException {
        ClientConnection cc = new ClientConnection(this, s);
        connectingUsers.add(cc);
        LinkedList<Object> tmpMessages = new LinkedList<Object>();
        while (!lobbyMessages.isEmpty()) {
            Object oo = lobbyMessages.remove();
            cc.writeObject(oo);
            tmpMessages.add(oo);
            Thread.currentThread();
            Thread.sleep(300L);
        }
        lobbyMessages = tmpMessages;
    }

    public synchronized boolean finalizeUser(String ouname, ClientConnection cc) {
        String uname = ouname;
        if (connectedUsers.containsKey(uname) || connectedUsers.contains(cc)) {
            cc.writeObject(new SD_Error("Already a user of that name or already connected. \nType \\rename &lt;new name&gt; to choose a different name"));
            this.log(cc, "failed [duplicate exists]");
            return false;
        }
        if (uname.length() > 10) {
            cc.writeObject(new SD_Error("Username too long.\nType \\rename &lt;new name&gt; to choose a different name"));
            this.log(cc, "failed [bad name]");
            return false;
        }
        if (uname.equals("server") || !uname.matches("[\\w_-]+?")) {
            cc.writeObject(new SD_Error("Invalid username " + uname + ".\n" + "Type \\rename &lt;new name&gt; to choose " + "a different name"));
            this.log(cc, "failed [bad name]");
            return false;
        }
        if (connectingUsers.remove(cc)) {
            cc.writeObject(new SD_ServerCap('\u0000', new Character(ChannelManager.allowUserChannels)));
            if (welcomeMessage != null) {
                cc.writeObject(new SD_Chat("server", welcomeMessage));
            }
            cc.writeObject(new SD_Channel(false, cc.channel, null));
            this.sendUserList(cc);
            Enumeration e = channels.enumerate();
            while (e.hasMoreElements()) {
                String channel = (String)e.nextElement();
                cc.writeObject(new SD_Channel(true, channel, channels.channelHasPass(channel)));
            }
            connectedUsers.put(uname, cc);
            this.broadcast(new SD_UserAdd(uname, false), uname, cc.channel);
            ++this.m_nUsers;
            this.broadcast(new SD_UpdateUserNumber(this.m_nUsers), cc.channel);
            EEGLABChatServer.updateUserExport();
            this.log(cc, "connected as " + uname);
            return true;
        }
        cc.writeObject(new SD_Error("invalid connection procedure, please try again"));
        return false;
    }

    public synchronized void sendUserList(ClientConnection cc) {
        Enumeration e = connectedUsers.keys();
        while (e.hasMoreElements()) {
            String un = (String)e.nextElement();
            if (cc.name.equals(un)) continue;
            ClientConnection o = (ClientConnection)connectedUsers.get(un);
            if (!o.channel.equals(cc.channel)) continue;
            cc.writeObject(new SD_UserAdd(un, false));
            if (!o.isAdmin()) continue;
            cc.writeObject(new SD_AdminAdd(un));
        }
        cc.writeObject(new SD_UserAdd(null, false));
    }

    public synchronized boolean sendTo(SocketData sd, String to) {
        ClientConnection o = (ClientConnection)connectedUsers.get(to);
        if (o != null) {
            o.writeObject(sd);
            return true;
        }
        return false;
    }

    public synchronized void broadcast(SocketData sd, String from) {
        Enumeration e = connectedUsers.keys();
        while (e.hasMoreElements()) {
            String to = (String)e.nextElement();
            if (to.equals(from)) continue;
            ClientConnection o = (ClientConnection)connectedUsers.get(to);
            o.writeObject(sd);
        }
    }

    public synchronized void broadcast(SocketData sd, String from, String c) {
        Enumeration e = connectedUsers.keys();
        if (c.equals("Lobby") && sd instanceof SD_Chat) {
            if (lobbyMessages.size() > 100) {
                lobbyMessages.poll();
            }
            lobbyMessages.add(sd);
        }
        while (e.hasMoreElements()) {
            String to = (String)e.nextElement();
            if (to.equals(from)) continue;
            ClientConnection o = (ClientConnection)connectedUsers.get(to);
            if (!o.channel.equals(c)) continue;
            o.writeObject(sd);
        }
    }

    public synchronized void delete(ClientConnection cc) {
        this.broadcast(new SD_UserDel(cc.name), null, cc.channel);
        --this.m_nUsers;
        this.broadcast(new SD_UpdateUserNumber(this.m_nUsers), null, cc.channel);
    }

    public synchronized void kill(ClientConnection cc) {
        try {
            if (cc.name != null && connectedUsers.remove(cc.name) == cc) {
                this.log(cc, String.valueOf(cc.name) + " disconnected");
                EEGLABChatServer.updateUserExport();
                if (channels.userDel(cc.channel)) {
                    this.broadcast(new SD_Channel(true, cc.channel, null), null);
                    this.chatLog(cc, false);
                }
                this.delete(cc);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            if (cc != null) {
                this.log("null pointer on kill: " + cc.name + " (" + cc.channel + ")");
            }
            this.log("got sent a null cc");
        }
    }

    public static String getTimestamp() {
        Calendar rightNow = Calendar.getInstance();
        return String.valueOf(rightNow.get(2)) + "/" + rightNow.get(5) + "/" + rightNow.get(1) + " " + rightNow.get(11) + ":" + rightNow.get(12) + ":" + rightNow.get(13);
    }

    private synchronized void log(String s) {
        if (sysLogOut != null) {
            sysLogOut.println(String.valueOf(EEGLABChatServer.getTimestamp()) + " - " + s);
            sysLogOut.flush();
        }
    }

    public void log(ClientConnection cc, String s) {
        this.log(String.valueOf(cc.ip) + " - " + s);
    }

    public synchronized boolean chatLog(ClientConnection cc, boolean start) {
        if (cc == null) {
            Enumeration e = channelFiles.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                ChatFileItem item = (ChatFileItem)channelFiles.get(name);
                this.closeLog(null, item);
            }
            return true;
        }
        ChatFileItem currentWriter = (ChatFileItem)channelFiles.get(cc.channel);
        if (start) {
            if (currentWriter != null && currentWriter.logging) {
                cc.writeObject(new SD_Error("already logging " + cc.channel));
                return false;
            }
            if (currentWriter == null) {
                currentWriter = new ChatFileItem();
                channelFiles.put(cc.channel, currentWriter);
            }
            String fname = String.valueOf(chatLogPath) + System.getProperty("file.separator") + "chat-" + cc.channel + ".log";
            try {
                currentWriter.chatOut = new PrintWriter(new BufferedOutputStream(new FileOutputStream(new File(fname), true)));
                currentWriter.chatOut.println("log started by " + (cc != null ? cc.name : "server") + " at " + EEGLABChatServer.getTimestamp());
                currentWriter.chatOut.println("====================================================");
                currentWriter.chatOut.flush();
                currentWriter.logging = true;
            }
            catch (FileNotFoundException e) {
                cc.writeObject(new SD_Error("error opening " + fname));
                running = false;
                return false;
            }
            return true;
        }
        return this.closeLog(cc, currentWriter);
    }

    private boolean closeLog(ClientConnection cc, ChatFileItem currentWriter) {
        if (currentWriter == null || currentWriter.chatOut == null) {
            return false;
        }
        currentWriter.chatOut.println("====================================================");
        currentWriter.chatOut.println("log stopped by " + (cc != null ? cc.name : "server") + " at " + EEGLABChatServer.getTimestamp());
        currentWriter.chatOut.println("====================================================");
        currentWriter.chatOut.flush();
        currentWriter.chatOut.close();
        currentWriter.chatOut = null;
        currentWriter.logging = false;
        if (cc != null) {
            channelFiles.remove(cc.channel);
        }
        return true;
    }

    public synchronized void chatLog(ClientConnection cc, String message) {
        ChatFileItem currentWriter = (ChatFileItem)channelFiles.get(cc.channel);
        if (currentWriter != null && currentWriter.logging && currentWriter.chatOut != null) {
            currentWriter.chatOut.println(String.valueOf(cc.name) + ": " + message);
            currentWriter.chatOut.flush();
        }
    }

    public static synchronized boolean updateUserExport() {
        if (userExportFile == null) {
            return false;
        }
        try {
            PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(new File(userExportFile), false)));
            Enumeration e = connectedUsers.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                String usr = (String)e.nextElement();
                ClientConnection o = (ClientConnection)connectedUsers.get(usr);
                pw.println(String.valueOf(usr) + " (" + o.channel + ")");
                ++i;
            }
            if (i == 0) {
                pw.println("(no connected users)");
            }
            pw.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("unable to access userExportFile: " + userExportFile);
            userExportFile = null;
        }
        return true;
    }

    public synchronized String newChannel(String name, String pass, ClientConnection cc) {
        String ret = channels.addUserChannel(name, pass, cc);
        if (ret != null) {
            return ret;
        }
        this.broadcast(new SD_Channel(true, name, pass == null ? null : ""), null);
        return null;
    }

    public synchronized boolean channelExists(String name) {
        return channels.channelExists(name);
    }

    @Override
    public void run() {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
        try {
            SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            SSLServerSocket sslIncoming = (SSLServerSocket)factory.createServerSocket(PORT);
            String[] enabledCipher = sslIncoming.getSupportedCipherSuites();
            sslIncoming.setEnabledCipherSuites(enabledCipher);
            this.log("Server Started");
            while (running) {
                SSLSocket s = (SSLSocket)sslIncoming.accept();
                this.newUser(s);
            }
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.log("Server Stopped");
    }

    EEGLABChatServer() {
        running = true;
    }

    public static void main(String[] args) {
        listeningServer = new EEGLABChatServer();
        connectingUsers = new LinkedList();
        connectedUsers = new Hashtable();
        channels = new ChannelManager();
        channelFiles = new Hashtable();
        lobbyMessages = new LinkedList<Object>();
        try {
            ConfigParser handler = new ConfigParser(listeningServer);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(serverConfigFile), (DefaultHandler)handler);
        }
        catch (Throwable t) {
            System.err.println("error parsing " + serverConfigFile);
            running = false;
        }
        try {
            sysLogOut = new PrintWriter(new BufferedOutputStream(new FileOutputStream(new File(sysLogFile), true)));
        }
        catch (FileNotFoundException e) {
            System.err.println(String.valueOf(sysLogFile) + " not found.");
            running = false;
        }
        EEGLABChatServer.updateUserExport();
        listeningServer.start();
        try {
            listeningServer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendText(String un, String message, boolean whisper, int size) {
        StringBuffer buff = new StringBuffer();
        HTMLDocument doc = (HTMLDocument)this.text.getDocument();
        HTMLEditorKit kit = (HTMLEditorKit)this.pane.getEditorKit();
        if (!"server".equals(un)) {
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll(">", "&gt;");
        }
        message = message.replaceAll("\n", "<br>");
        buff.append(un);
        buff.append("</b></font>");
        buff.append("&nbsp;&nbsp;:&nbsp;");
        if (whisper) {
            buff.append("<i>");
        }
        char[] tmp = message.toCharArray();
        if (buff.length() > 0) {
            try {
                kit.insertHTML(doc, doc.getLength(), buff.toString(), 0, 0, HTML.Tag.FONT);
                this.text.setCaretPosition(doc.getLength());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private class ChatFileItem {
        public boolean logging = false;
        public PrintWriter chatOut = null;

        ChatFileItem() {
        }
    }

    class NameNumPair {
        public String name;
        public int number;

        NameNumPair() {
        }
    }

    public class ShutdownThread
    extends Thread {
        private EEGLABChatServer lcs;

        ShutdownThread(EEGLABChatServer l) {
            this.lcs = l;
        }

        @Override
        public void run() {
            EEGLABChatServer.this.log("Server Stopped");
            sysLogOut.close();
            EEGLABChatServer.this.chatLog(null, false);
        }
    }
}

